/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;
import org.ops4j.pax.url.mvn.internal.DownloadableArtifact;
import org.ops4j.pax.url.mvn.internal.Parser;
import org.ops4j.pax.url.mvn.internal.Version;
import org.ops4j.pax.url.mvn.internal.VersionRange;
import org.ops4j.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
extends URLConnection {
    private static final Log LOG;
    private static final String Ix2 = "  ";
    private static final String Ix4 = "    ";
    private Parser m_parser;
    private final MavenConfiguration m_configuration;
    static /* synthetic */ Class class$org$ops4j$pax$url$mvn$internal$Connection;

    public Connection(URL url, MavenConfiguration configuration) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL cannot be null");
        NullArgumentException.validateNotNull(configuration, "Service configuration");
        this.m_configuration = configuration;
        this.m_parser = new Parser(url.getPath());
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        LOG.debug(new StringBuffer().append("Resolving [").append(this.url.toExternalForm()).append("]").toString());
        Set<DownloadableArtifact> defaultDownloadables = this.collectDefaultPossibleDownloads();
        if (LOG.isTraceEnabled()) {
            LOG.trace(new StringBuffer().append("Possible default download locations for [").append(this.url.toExternalForm()).append("]").toString());
            for (DownloadableArtifact artifact : defaultDownloadables) {
                LOG.trace(new StringBuffer().append(Ix2).append(artifact).toString());
            }
        }
        for (DownloadableArtifact artifact : defaultDownloadables) {
            LOG.trace(new StringBuffer().append("Downloading [").append(artifact).append("]").toString());
            try {
                this.m_configuration.enableProxy(artifact.getArtifactURL());
                return artifact.getInputStream();
            }
            catch (IOException ignore) {
                LOG.debug(new StringBuffer().append("  Could not download [").append(artifact).append("]").toString());
                LOG.trace(new StringBuffer().append("  Reason [").append(ignore.getClass().getName()).append(": ").append(ignore.getMessage()).append("]").toString());
            }
        }
        Set<DownloadableArtifact> downloadables = this.collectPossibleDownloads();
        if (LOG.isTraceEnabled()) {
            LOG.trace(new StringBuffer().append("Possible download locations for [").append(this.url.toExternalForm()).append("]").toString());
            for (DownloadableArtifact artifact : downloadables) {
                LOG.trace(new StringBuffer().append(Ix2).append(artifact).toString());
            }
        }
        for (DownloadableArtifact artifact : downloadables) {
            LOG.trace(new StringBuffer().append("Downloading [").append(artifact).append("]").toString());
            try {
                this.m_configuration.enableProxy(artifact.getArtifactURL());
                return artifact.getInputStream();
            }
            catch (IOException ignore) {
                LOG.debug(new StringBuffer().append("  Could not download [").append(artifact).append("]").toString());
                LOG.trace(new StringBuffer().append("  Reason [").append(ignore.getClass().getName()).append(": ").append(ignore.getMessage()).append("]").toString());
            }
        }
        throw new RuntimeException(new StringBuffer().append("URL [").append(this.url.toExternalForm()).append("] could not be resolved.").toString());
    }

    private Set<DownloadableArtifact> collectPossibleDownloads() throws MalformedURLException {
        ArrayList<MavenRepositoryURL> repositories = new ArrayList<MavenRepositoryURL>();
        repositories.addAll(this.m_configuration.getRepositories());
        if (this.m_parser.getRepositoryURL() != null) {
            repositories.add(repositories.size() == 0 ? 0 : 1, this.m_parser.getRepositoryURL());
        }
        return this.doCollectPossibleDownloads(repositories);
    }

    private Set<DownloadableArtifact> collectDefaultPossibleDownloads() throws MalformedURLException {
        return this.doCollectPossibleDownloads(this.m_configuration.getDefaultRepositories());
    }

    private Set<DownloadableArtifact> doCollectPossibleDownloads(List<MavenRepositoryURL> repositories) throws MalformedURLException {
        TreeSet<DownloadableArtifact> downloadables = new TreeSet<DownloadableArtifact>(new DownloadComparator());
        boolean isLatest = this.m_parser.getVersion().contains("LATEST");
        boolean isSnapshot = this.m_parser.getVersion().endsWith("SNAPSHOT");
        VersionRange versionRange = null;
        if (!isLatest && !isSnapshot) {
            try {
                versionRange = new VersionRange(this.m_parser.getVersion());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        boolean isVersionRange = versionRange != null;
        boolean isExactVersion = !isLatest && !isSnapshot && !isVersionRange;
        int priority = 0;
        for (MavenRepositoryURL repositoryURL : repositories) {
            LOG.debug(new StringBuffer().append("Collecting versions from repository [").append(repositoryURL).append("]").toString());
            ++priority;
            try {
                if (isExactVersion) {
                    downloadables.add(this.resolveExactVersion(repositoryURL, priority));
                    continue;
                }
                if (isSnapshot) {
                    DownloadableArtifact snapshot = this.resolveSnapshotVersion(repositoryURL, priority, this.m_parser.getVersion());
                    downloadables.add(snapshot);
                    if (!snapshot.isLocalSnapshotBuild()) continue;
                    break;
                }
                Document metadata = this.getMetadata(repositoryURL.getURL(), new String[]{this.m_parser.getArtifactLocalMetdataPath(), this.m_parser.getArtifactMetdataPath()});
                if (isLatest) {
                    downloadables.add(this.resolveLatestVersion(metadata, repositoryURL, priority));
                    continue;
                }
                downloadables.addAll(this.resolveRangeVersions(metadata, repositoryURL, priority, versionRange));
            }
            catch (IOException ignore) {
                LOG.debug(new StringBuffer().append("  Skipping repository [").append(repositoryURL).append("], reason: ").append(ignore.getMessage()).toString());
            }
        }
        return downloadables;
    }

    private Document getMetadata(URL repositoryURL, String[] metadataLocations) throws IOException {
        LOG.debug("  Resolving metadata");
        InputStream inputStream = null;
        String foundLocation = null;
        for (String location : metadataLocations) {
            try {
                inputStream = this.prepareInputStream(repositoryURL, location);
                foundLocation = location;
                LOG.trace(new StringBuffer().append("    Metadata found: [").append(location).append("]").toString());
                break;
            }
            catch (IOException ignore) {
                LOG.trace(new StringBuffer().append("    Metadata not found: [").append(location).append("]").toString());
            }
        }
        if (inputStream == null) {
            throw new IOException(new StringBuffer().append("Metadata not found in repository [").append(repositoryURL).append("]").toString());
        }
        try {
            return XmlUtils.parseDoc(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw this.initIOException(new StringBuffer().append("Metadata [").append(foundLocation).append("] could not be parsed.").toString(), e);
        }
        catch (SAXException e) {
            throw this.initIOException(new StringBuffer().append("Metadata [").append(foundLocation).append("] could not be parsed.").toString(), e);
        }
    }

    private DownloadableArtifact resolveExactVersion(MavenRepositoryURL repositoryURL, int priority) throws IOException {
        if (!repositoryURL.isReleasesEnabled()) {
            throw new IOException("Releases not enabled");
        }
        LOG.debug("  Resolving exact version");
        return new DownloadableArtifact(this.m_parser.getVersion(), priority, repositoryURL.getURL(), this.m_parser.getArtifactPath(), false, this.m_configuration.getCertificateCheck());
    }

    private DownloadableArtifact resolveLatestVersion(Document metadata, MavenRepositoryURL repositoryURL, int priority) throws IOException {
        LOG.debug("  Resolving latest version");
        String version = XmlUtils.getTextContentOfElement(metadata, "versioning/versions/version[last]");
        if (version != null) {
            if (version.endsWith("SNAPSHOT")) {
                return this.resolveSnapshotVersion(repositoryURL, priority, version);
            }
            return new DownloadableArtifact(version, priority, repositoryURL.getURL(), this.m_parser.getArtifactPath(version), false, this.m_configuration.getCertificateCheck());
        }
        throw new IOException("LATEST version could not be resolved.");
    }

    private DownloadableArtifact resolveSnapshotVersion(MavenRepositoryURL repositoryURL, int priority, String version) throws IOException {
        if (!repositoryURL.isSnapshotsEnabled()) {
            throw new IOException("Snapshots not enabled");
        }
        LOG.debug(new StringBuffer().append("  Resolving snapshot version [").append(version).append("]").toString());
        try {
            Document snapshotMetadata = this.getMetadata(repositoryURL.getURL(), new String[]{this.m_parser.getVersionLocalMetadataPath(version), this.m_parser.getVersionMetadataPath(version)});
            String timestamp = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/snapshot/timestamp");
            String buildNumber = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/snapshot/buildNumber");
            String localSnapshot = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/snapshot/localCopy");
            if (timestamp != null && buildNumber != null) {
                return new DownloadableArtifact(this.m_parser.getSnapshotVersion(version, timestamp, buildNumber), priority, repositoryURL.getURL(), this.m_parser.getSnapshotPath(version, timestamp, buildNumber), localSnapshot != null, this.m_configuration.getCertificateCheck());
            }
            String lastUpdated = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/lastUpdated");
            if (lastUpdated != null && lastUpdated.length() > 8) {
                lastUpdated = new StringBuffer().append(lastUpdated.substring(0, 8)).append(".").append(lastUpdated.substring(8)).toString();
                return new DownloadableArtifact(this.m_parser.getSnapshotVersion(version, lastUpdated, "0"), priority, repositoryURL.getURL(), this.m_parser.getArtifactPath(version), localSnapshot != null, this.m_configuration.getCertificateCheck());
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return new DownloadableArtifact(this.m_parser.getVersion(), priority, repositoryURL.getURL(), this.m_parser.getArtifactPath(), false, this.m_configuration.getCertificateCheck());
    }

    private List<DownloadableArtifact> resolveRangeVersions(Document metadata, MavenRepositoryURL repositoryURL, int priority, VersionRange versionRange) throws IOException {
        LOG.debug(new StringBuffer().append("  Resolving versions in range [").append(versionRange).append("]").toString());
        ArrayList<DownloadableArtifact> downladables = new ArrayList<DownloadableArtifact>();
        List<Element> elements = XmlUtils.getElements(metadata, "versioning/versions/version");
        if (elements != null && elements.size() > 0) {
            for (Element element : elements) {
                Version version;
                String versionString = XmlUtils.getTextContent(element);
                if (versionString == null || !versionRange.includes(version = new Version(versionString))) continue;
                if (versionString.endsWith("SNAPSHOT")) {
                    downladables.add(this.resolveSnapshotVersion(repositoryURL, priority, versionString));
                    continue;
                }
                downladables.add(new DownloadableArtifact(versionString, priority, repositoryURL.getURL(), this.m_parser.getArtifactPath(versionString), false, this.m_configuration.getCertificateCheck()));
            }
        }
        return downladables;
    }

    private InputStream prepareInputStream(URL repositoryURL, String path) throws IOException {
        String repository = repositoryURL.toExternalForm();
        if (!repository.endsWith("/")) {
            repository = new StringBuffer().append(repository).append("/").toString();
        }
        this.m_configuration.enableProxy(repositoryURL);
        URL url = new URL(new StringBuffer().append(repository).append(path).toString());
        LOG.trace(new StringBuffer().append("Reading ").append(url.toExternalForm()).toString());
        return URLUtils.prepareInputStream(url, this.m_configuration.getCertificateCheck() == false);
    }

    private IOException initIOException(String message, Exception cause) {
        IOException exception = new IOException(message);
        exception.initCause(cause);
        return exception;
    }

    static {
        Class<?> clazz = class$org$ops4j$pax$url$mvn$internal$Connection;
        if (clazz == null) {
            clazz = class$org$ops4j$pax$url$mvn$internal$Connection = new Connection[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog(clazz);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DownloadComparator
    implements Comparator<DownloadableArtifact> {
        private DownloadComparator() {
        }

        @Override
        public int compare(DownloadableArtifact first, DownloadableArtifact second) {
            int result = -1 * first.getVersion().compareTo(second.getVersion());
            if (result == 0) {
                if (first.getPriority() < second.getPriority()) {
                    result = -1;
                } else if (first.getPriority() > second.getPriority()) {
                    result = 1;
                }
            }
            return result;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((DownloadableArtifact)x0, (DownloadableArtifact)x1);
        }
    }
}

