/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.osgi.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.overlord.commons.osgi.Messages;

public class VfsBundle {
    private File vfsBundleDir;
    private File vfsBundleIndexFile;
    private Map<String, File> index = new HashMap<String, File>();

    public VfsBundle(Bundle bundle) {
        this.vfsBundleDir = this.getOrCreateVfsBundleDir(bundle);
        this.vfsBundleIndexFile = new File(this.vfsBundleDir, "index.properties");
        if (this.vfsBundleIndexFile.isFile()) {
            this.readVfsBundle();
        } else {
            this.createVfsBundle(bundle);
        }
    }

    private void createVfsBundle(Bundle bundle) {
        Enumeration entries = bundle.findEntries("", "*.*", true);
        while (entries.hasMoreElements()) {
            Object nextElement = entries.nextElement();
            try {
                URL entryURL = new URL(String.valueOf(nextElement));
                File entryFile = this.writeBundleEntry(entryURL);
                if (this.isJar(entryFile)) {
                    this.indexJar(entryFile);
                    continue;
                }
                if (!this.isManifest(entryFile)) continue;
                this.indexBundle(entryFile);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.writeIndex();
    }

    private File writeBundleEntry(URL entryURL) {
        File file;
        String path = entryURL.getPath();
        if (path == null || path.trim().length() == 0 || path.endsWith("/")) {
            return null;
        }
        File entryFile = new File(this.vfsBundleDir, "content/" + path);
        entryFile.getParentFile().mkdirs();
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = entryURL.openStream();
            os = new FileOutputStream(entryFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            file = entryFile;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        return file;
    }

    private boolean isJar(File entryFile) {
        if (entryFile == null) {
            return false;
        }
        return entryFile.getName().toLowerCase().endsWith(".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexJar(File entryFile) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(entryFile);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry != null) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                String hash = DigestUtils.shaHex((InputStream)inputStream);
                this.index.put(hash, entryFile);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isManifest(File entryFile) {
        if (entryFile == null) {
            return false;
        }
        return entryFile.getName().equals("MANIFEST.MF");
    }

    private void indexBundle(File entryFile) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(entryFile);
            String hash = DigestUtils.shaHex((InputStream)is);
            this.index.put(hash, new File(this.vfsBundleDir, "content"));
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private void writeIndex() {
        Properties props = new Properties();
        for (Map.Entry<String, File> entry : this.index.entrySet()) {
            String value = this.vfsBundleDir.toURI().relativize(entry.getValue().toURI()).toString();
            props.setProperty(entry.getKey(), value);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.vfsBundleIndexFile);
            props.store(writer, Messages.getString("VfsBundle.GeneratedBundleIndex"));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private void readVfsBundle() {
        Properties props = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(this.vfsBundleIndexFile);
            props.load(reader);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = String.valueOf(entry.getKey());
                String val = String.valueOf(entry.getValue());
                this.index.put(key, new File(this.vfsBundleDir, val));
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    private File getOrCreateVfsBundleDir(Bundle bundle) {
        String karafHome = System.getProperty("karaf.home");
        if (karafHome == null) {
            throw new RuntimeException(Messages.getString("VfsBundle.SystemPropertyMissing"));
        }
        File tmpDir = new File(karafHome, "data/tmp/errai-vfs/" + bundle.getBundleId());
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File asFile(URL url) {
        InputStream manifestStream;
        block4: {
            File file;
            manifestStream = null;
            try {
                String manifestUrl = "bundle://" + url.getHost() + ":" + url.getPort() + "/META-INF/MANIFEST.MF";
                URL manifestURL = new URL(manifestUrl);
                manifestStream = manifestURL.openStream();
                String manifestHash = DigestUtils.shaHex((InputStream)manifestStream);
                File jarFile = this.index.get(manifestHash);
                if (jarFile == null) break block4;
                file = jarFile;
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(manifestStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(manifestStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)manifestStream);
            return file;
        }
        IOUtils.closeQuietly((InputStream)manifestStream);
        this.throwNotFoundError(url);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void throwNotFoundError(URL url) {
        InputStream manifestStream = null;
        StringBuilder builder = new StringBuilder();
        try {
            String manifestPath = "META-INF/MANIFEST.MF";
            URL manifestURL = new URL(url.toExternalForm() + manifestPath);
            manifestStream = manifestURL.openStream();
            Manifest manifest = new Manifest(manifestStream);
            Attributes attributes = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                String key = String.valueOf(entry.getKey());
                String value = String.valueOf(entry.getValue());
                builder.append(key).append(": ").append(value).append("\n");
            }
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(manifestStream);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(manifestStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)manifestStream);
        throw new RuntimeException("Failed to create a Vfs.Dir for URL: " + url + "\n--Manifest--\n====================" + builder.toString());
    }
}

