/*
 * Decompiled with CFR 0.152.
 */
package org.thorntail.teiid.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader;
import org.thorntail.teiid.VDBArchive;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;
import org.wildfly.swarm.spi.api.DependenciesContainer;

@ApplicationScoped
public class DefaultVDBDeploymentFactory
extends DefaultDeploymentFactory {
    public static VDBArchive archiveFromCurrentApp() throws Exception {
        Configuration config = ShrinkWrap.getDefaultDomain().getConfiguration();
        ArrayList<Object> existing = new ArrayList<Object>();
        Iterator it = config.getClassLoaders().iterator();
        while (it.hasNext()) {
            existing.add(it.next());
        }
        existing.add(VDBArchive.class.getClassLoader());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.classLoaders(existing);
        builder.extensionLoader((ExtensionLoader)new ServiceExtensionLoader(existing));
        Domain domain = ShrinkWrap.createDomain((ConfigurationBuilder)builder);
        VDBArchive archive = (VDBArchive)domain.getArchiveFactory().create(VDBArchive.class, DefaultVDBDeploymentFactory.determineName());
        DefaultVDBDeploymentFactory factory = new DefaultVDBDeploymentFactory();
        factory.setup(archive);
        archive.addAllDependencies();
        return archive;
    }

    public int getPriority() {
        return 0;
    }

    public String getType() {
        return "vdb";
    }

    public Archive<?> create() throws Exception {
        return DefaultVDBDeploymentFactory.archiveFromCurrentApp();
    }

    public boolean setupUsingMaven(Archive<?> givenArchive) throws Exception {
        final DependenciesContainer archive = (DependenciesContainer)givenArchive;
        FileSystemLayout fsLayout = FileSystemLayout.create();
        final Path classes = fsLayout.resolveBuildClassesDir();
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), "classes/" + DefaultVDBDeploymentFactory.this.convertSeparators(simple));
                    if (simple.toString().contains("config")) {
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultVDBDeploymentFactory.this.convertSeparators(simple));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected static String determineName() {
        return DefaultDeploymentFactory.determineName((String)".vdb");
    }
}

