/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.DataByteArrayOutputStream;
import org.apache.kahadb.util.LinkedNode;
import org.apache.kahadb.util.LinkedNodeList;

class DataFileAppender {
    protected final Journal journal;
    protected final Map<WriteKey, WriteCommand> inflightWrites;
    protected final Object enqueueMutex = new Object(){};
    protected WriteBatch nextWriteBatch;
    protected boolean shutdown;
    protected IOException firstAsyncException;
    protected final CountDownLatch shutdownDone = new CountDownLatch(1);
    protected int maxWriteBatchSize;
    private boolean running;
    private Thread thread;
    public static final String PROPERTY_LOG_WRITE_STAT_WINDOW = "org.apache.kahadb.journal.appender.WRITE_STAT_WINDOW";
    public static final int maxStat = Integer.parseInt(System.getProperty("org.apache.kahadb.journal.appender.WRITE_STAT_WINDOW", "0"));
    int statIdx = 0;
    int[] stats = new int[maxStat];

    public DataFileAppender(Journal dataManager) {
        this.journal = dataManager;
        this.inflightWrites = this.journal.getInflightWrites();
        this.maxWriteBatchSize = this.journal.getWriteBatchSize();
    }

    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, sync);
        WriteBatch batch = this.enqueue(write);
        location.setLatch(batch.latch);
        if (sync) {
            try {
                batch.latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            IOException exception = batch.exception.get();
            if (exception != null) {
                throw exception;
            }
        }
        return location;
    }

    public Location storeItem(ByteSequence data, byte type, Runnable onComplete) throws IOException {
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, onComplete);
        WriteBatch batch = this.enqueue(write);
        location.setLatch(batch.latch);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteBatch enqueue(WriteCommand write) throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            block14: {
                if (this.shutdown) {
                    throw new IOException("Async Writter Thread Shutdown");
                }
                if (!this.running) {
                    this.running = true;
                    this.thread = new Thread(){

                        public void run() {
                            DataFileAppender.this.processQueue();
                        }
                    };
                    this.thread.setPriority(10);
                    this.thread.setDaemon(true);
                    this.thread.setName("ActiveMQ Data File Writer");
                    this.thread.start();
                    this.firstAsyncException = null;
                }
                if (this.firstAsyncException != null) {
                    throw this.firstAsyncException;
                }
                do {
                    if (this.nextWriteBatch == null) {
                        DataFile file = this.journal.getCurrentWriteFile();
                        if (file.getLength() > this.journal.getMaxFileLength()) {
                            file = this.journal.rotateWriteFile();
                        }
                        this.nextWriteBatch = new WriteBatch(file, file.getLength(), write);
                        this.enqueueMutex.notifyAll();
                        break block14;
                    }
                    if (this.nextWriteBatch.canAppend(write)) {
                        this.nextWriteBatch.append(write);
                        break block14;
                    }
                    try {
                        while (this.nextWriteBatch != null) {
                            long start = System.currentTimeMillis();
                            this.enqueueMutex.wait();
                            if (maxStat <= 0) continue;
                            System.err.println("Watiting for write to finish with full batch... millis: " + (System.currentTimeMillis() - start));
                        }
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                } while (!this.shutdown);
                throw new IOException("Async Writter Thread Shutdown");
            }
            if (!write.sync) {
                this.inflightWrites.put(new WriteKey(write.location), write);
            }
            return this.nextWriteBatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.running) {
                    this.enqueueMutex.notifyAll();
                } else {
                    this.shutdownDone.countDown();
                }
            }
        }
        try {
            this.shutdownDone.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processQueue() {
        block45: {
            block41: {
                dataFile = null;
                file = null;
                wb = null;
                try {
                    try {
                        buff = new DataByteArrayOutputStream(this.maxWriteBatchSize);
                        while (true) {
                            block40: {
                                o = null;
                                var6_9 = this.enqueueMutex;
                                synchronized (var6_9) {
                                    while (true) {
                                        if (this.nextWriteBatch != null) {
                                            o = this.nextWriteBatch;
                                            this.nextWriteBatch = null;
                                            this.enqueueMutex.notifyAll();
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 18, 39, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var6_9
                                            wb = o;
                                            if (dataFile != wb.dataFile) {
                                                break;
                                            }
                                            break block40;
                                        }
                                        if (this.shutdown) {
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 18, 38, 8] lbl22 : MonitorExitStatement: MONITOREXIT : var6_9
                                            var14_16 = null;
                                            break block41;
                                        }
                                        this.enqueueMutex.wait();
                                    }
                                }
                                if (file != null) {
                                    file.setLength(dataFile.getLength());
                                    dataFile.closeRandomAccessFile(file);
                                }
                                if ((file = (dataFile = wb.dataFile).openRandomAccessFile()).length() < (long)this.journal.preferedFileLength) {
                                    file.setLength(this.journal.preferedFileLength);
                                }
                            }
                            buff.reset();
                            buff.writeInt(Journal.BATCH_CONTROL_RECORD_SIZE);
                            buff.writeByte(2);
                            buff.write(Journal.BATCH_CONTROL_RECORD_MAGIC);
                            buff.writeInt(0);
                            buff.writeLong(0L);
                            forceToDisk = false;
                            for (write = wb.writes.getHead(); write != null; forceToDisk |= write.sync | write.onComplete != null, write = (WriteCommand)write.getNext()) {
                                buff.writeInt(write.location.getSize());
                                buff.writeByte(write.location.getType());
                                buff.write(write.data.getData(), write.data.getOffset(), write.data.getLength());
                            }
                            sequence = buff.toByteSequence();
                            buff.reset();
                            buff.skip(5 + Journal.BATCH_CONTROL_RECORD_MAGIC.length);
                            buff.writeInt(sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE);
                            if (this.journal.isChecksum()) {
                                checksum = new Adler32();
                                checksum.update(sequence.getData(), sequence.getOffset() + Journal.BATCH_CONTROL_RECORD_SIZE, sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE);
                                buff.writeLong(checksum.getValue());
                            }
                            file.seek(WriteBatch.access$000(wb));
                            if (DataFileAppender.maxStat > 0) {
                                if (this.statIdx < DataFileAppender.maxStat) {
                                    this.stats[this.statIdx++] = sequence.getLength();
                                } else {
                                    all = 0L;
                                    while (this.statIdx > 0) {
                                        all += (long)this.stats[--this.statIdx];
                                    }
                                    System.err.println("Ave writeSize: " + all / (long)DataFileAppender.maxStat);
                                }
                            }
                            file.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                            replicationTarget = this.journal.getReplicationTarget();
                            if (replicationTarget != null) {
                                replicationTarget.replicate(wb.writes.getHead().location, sequence, forceToDisk);
                            }
                            if (forceToDisk) {
                                file.getFD().sync();
                            }
                            lastWrite = wb.writes.getTail();
                            this.journal.setLastAppendLocation(lastWrite.location);
                            for (write = wb.writes.getHead(); write != null; write = (WriteCommand)write.getNext()) {
                                if (!write.sync) {
                                    this.inflightWrites.remove(new WriteKey(write.location));
                                }
                                if (write.onComplete == null) continue;
                                try {
                                    write.onComplete.run();
                                    continue;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            wb.latch.countDown();
                        }
                    }
                    catch (IOException e) {
                        var5_8 = this.enqueueMutex;
                        synchronized (var5_8) {
                            this.firstAsyncException = e;
                            if (wb != null) {
                                wb.exception.set(e);
                                wb.latch.countDown();
                            }
                            if (this.nextWriteBatch != null) {
                                this.nextWriteBatch.exception.set(e);
                                this.nextWriteBatch.latch.countDown();
                            }
                        }
                        var14_17 = null;
                        try {
                            if (file != null) {
                                dataFile.closeRandomAccessFile(file);
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        this.shutdownDone.countDown();
                        this.running = false;
                        return;
                    }
                    catch (InterruptedException e) {
                        block43: {
                            var14_18 = null;
                            ** try [egrp 6[TRYBLOCK] [14 : 824->836)] { 
lbl111:
                            // 1 sources

                            if (file != null) {
                                dataFile.closeRandomAccessFile(file);
                            }
                            break block43;
lbl114:
                            // 1 sources

                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        this.shutdownDone.countDown();
                        this.running = false;
                        return;
                    }
                }
                catch (Throwable var13_24) {
                    block44: {
                        var14_19 = null;
                        ** try [egrp 6[TRYBLOCK] [14 : 824->836)] { 
lbl124:
                        // 1 sources

                        if (file != null) {
                            dataFile.closeRandomAccessFile(file);
                        }
                        break block44;
lbl127:
                        // 1 sources

                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    this.shutdownDone.countDown();
                    this.running = false;
                    throw var13_24;
                }
            }
            ** try [egrp 6[TRYBLOCK] [14 : 824->836)] { 
lbl135:
            // 1 sources

            if (file != null) {
                dataFile.closeRandomAccessFile(file);
            }
            break block45;
lbl138:
            // 1 sources

            catch (Throwable ignore) {
                // empty catch block
            }
        }
        this.shutdownDone.countDown();
        this.running = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriteCommand
    extends LinkedNode<WriteCommand> {
        public final Location location;
        public final ByteSequence data;
        final boolean sync;
        public final Runnable onComplete;

        public WriteCommand(Location location, ByteSequence data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
            this.onComplete = null;
        }

        public WriteCommand(Location location, ByteSequence data, Runnable onComplete) {
            this.location = location;
            this.data = data;
            this.onComplete = onComplete;
            this.sync = false;
        }
    }

    public class WriteBatch {
        public final DataFile dataFile;
        public final LinkedNodeList<WriteCommand> writes = new LinkedNodeList();
        public final CountDownLatch latch = new CountDownLatch(1);
        private final int offset;
        public int size = Journal.BATCH_CONTROL_RECORD_SIZE;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, int offset, WriteCommand write) throws IOException {
            this.dataFile = dataFile;
            this.offset = offset;
            this.dataFile.incrementLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.size = Journal.BATCH_CONTROL_RECORD_SIZE;
            DataFileAppender.this.journal.addToTotalLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.append(write);
        }

        public boolean canAppend(WriteCommand write) {
            int newSize = this.size + write.location.getSize();
            return newSize < DataFileAppender.this.maxWriteBatchSize && this.offset + newSize <= DataFileAppender.this.journal.getMaxFileLength();
        }

        public void append(WriteCommand write) throws IOException {
            this.writes.addLast(write);
            write.location.setDataFileId(this.dataFile.getDataFileId());
            write.location.setOffset(this.offset + this.size);
            int s = write.location.getSize();
            this.size += s;
            this.dataFile.incrementLength(s);
            DataFileAppender.this.journal.addToTotalLength(s);
        }

        static /* synthetic */ int access$000(WriteBatch x0) {
            return x0.offset;
        }
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }
}

