/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.filter.AnyDestination;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.store.kahadb.MultiKahaDBTransactionStore;
import org.apache.activemq.store.kahadb.TransactionIdTransformer;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaXATransactionId;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKahaDBPersistenceAdapter
extends DestinationMap
implements PersistenceAdapter,
BrokerServiceAware {
    static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBPersistenceAdapter.class);
    static final ActiveMQDestination matchAll = new AnyDestination(new ActiveMQDestination[]{new ActiveMQQueue(">"), new ActiveMQTopic(">")});
    final int LOCAL_FORMAT_ID_MAGIC = Integer.valueOf(System.getProperty("org.apache.activemq.store.kahadb.MultiKahaDBTransactionStore.localXaFormatId", "61616"));
    BrokerService brokerService;
    List<KahaDBPersistenceAdapter> adapters = new LinkedList<KahaDBPersistenceAdapter>();
    private File directory = new File(IOHelper.getDefaultDataDirectory() + File.separator + "mKahaDB");
    MultiKahaDBTransactionStore transactionStore = new MultiKahaDBTransactionStore(this);
    TransactionIdTransformer transactionIdTransformer = new TransactionIdTransformer(){

        @Override
        public KahaTransactionInfo transform(TransactionId txid) {
            if (txid == null) {
                return null;
            }
            KahaTransactionInfo rc = new KahaTransactionInfo();
            KahaXATransactionId kahaTxId = new KahaXATransactionId();
            if (txid.isLocalTransaction()) {
                LocalTransactionId t = (LocalTransactionId)txid;
                kahaTxId.setBranchQualifier(new Buffer(Long.toString(t.getValue()).getBytes(Charset.forName("utf-8"))));
                kahaTxId.setGlobalTransactionId(new Buffer(t.getConnectionId().getValue().getBytes(Charset.forName("utf-8"))));
                kahaTxId.setFormatId(MultiKahaDBPersistenceAdapter.this.LOCAL_FORMAT_ID_MAGIC);
            } else {
                XATransactionId t = (XATransactionId)txid;
                kahaTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
                kahaTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
                kahaTxId.setFormatId(t.getFormatId());
            }
            rc.setXaTransactionId(kahaTxId);
            return rc;
        }
    };

    public void setFilteredPersistenceAdapters(List entries) {
        for (Object entry : entries) {
            FilteredKahaDBPersistenceAdapter filteredAdapter = (FilteredKahaDBPersistenceAdapter)entry;
            KahaDBPersistenceAdapter adapter = filteredAdapter.getPersistenceAdapter();
            if (filteredAdapter.getDestination() == null) {
                filteredAdapter.setDestination(matchAll);
            }
            if (filteredAdapter.isPerDestination()) {
                this.configureDirectory(adapter, null);
                continue;
            }
            this.configureDirectory(adapter, this.nameFromDestinationFilter(filteredAdapter.getDestination()));
            this.configureAdapter(adapter);
            this.adapters.add(adapter);
        }
        super.setEntries(entries);
    }

    private String nameFromDestinationFilter(ActiveMQDestination destination) {
        if (destination.getQualifiedName().length() > IOHelper.getMaxFileNameLength()) {
            LOG.warn("Destination name is longer than 'MaximumFileNameLength' system property, potential problem with recovery can result from name truncation.");
        }
        return IOHelper.toFileSystemSafeName(destination.getQualifiedName());
    }

    public boolean isLocalXid(TransactionId xid) {
        return xid instanceof XATransactionId && ((XATransactionId)xid).getFormatId() == this.LOCAL_FORMAT_ID_MAGIC;
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.checkpoint(sync);
        }
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        PersistenceAdapter persistenceAdapter = this.getMatchingPersistenceAdapter(destination);
        return this.transactionStore.proxy(persistenceAdapter.createTransactionStore(), persistenceAdapter.createQueueMessageStore(destination));
    }

    private PersistenceAdapter getMatchingPersistenceAdapter(ActiveMQDestination destination) {
        Object result = this.chooseValue(destination);
        if (result == null) {
            throw new RuntimeException("No matching persistence adapter configured for destination: " + destination + ", options:" + this.adapters);
        }
        FilteredKahaDBPersistenceAdapter filteredAdapter = (FilteredKahaDBPersistenceAdapter)result;
        if (filteredAdapter.getDestination() == matchAll && filteredAdapter.isPerDestination()) {
            filteredAdapter = this.addAdapter(filteredAdapter, destination);
            if (LOG.isTraceEnabled()) {
                LOG.info("created per destination adapter for: " + destination + ", " + result);
            }
        }
        this.startAdapter(filteredAdapter.getPersistenceAdapter(), destination.getQualifiedName());
        return filteredAdapter.getPersistenceAdapter();
    }

    private void startAdapter(KahaDBPersistenceAdapter kahaDBPersistenceAdapter, String destination) {
        try {
            kahaDBPersistenceAdapter.start();
        }
        catch (Exception e) {
            RuntimeException detail = new RuntimeException("Failed to start per destination persistence adapter for destination: " + destination + ", options:" + this.adapters, e);
            LOG.error(detail.toString(), e);
            throw detail;
        }
    }

    private void stopAdapter(KahaDBPersistenceAdapter kahaDBPersistenceAdapter, String destination) {
        try {
            kahaDBPersistenceAdapter.stop();
        }
        catch (Exception e) {
            RuntimeException detail = new RuntimeException("Failed to stop per destination persistence adapter for destination: " + destination + ", options:" + this.adapters, e);
            LOG.error(detail.toString(), e);
            throw detail;
        }
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        PersistenceAdapter persistenceAdapter = this.getMatchingPersistenceAdapter(destination);
        return this.transactionStore.proxy(persistenceAdapter.createTransactionStore(), persistenceAdapter.createTopicMessageStore(destination));
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.deleteAllMessages();
        }
        this.transactionStore.deleteAllMessages();
        IOHelper.deleteChildren(this.getDirectory());
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> results = new HashSet<ActiveMQDestination>();
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            results.addAll(persistenceAdapter.getDestinations());
        }
        return results;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        long maxId = -1L;
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            maxId = Math.max(maxId, persistenceAdapter.getLastMessageBrokerSequenceId());
        }
        return maxId;
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        long maxId = -1L;
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            maxId = Math.max(maxId, persistenceAdapter.getLastProducerSequenceId(id));
        }
        return maxId;
    }

    @Override
    public void removeQueueMessageStore(ActiveMQQueue destination) {
        PersistenceAdapter adapter = this.getMatchingPersistenceAdapter(destination);
        if (adapter instanceof KahaDBPersistenceAdapter) {
            adapter.removeQueueMessageStore(destination);
            this.removeMessageStore((KahaDBPersistenceAdapter)adapter, destination);
            this.removeAll(destination);
        }
    }

    @Override
    public void removeTopicMessageStore(ActiveMQTopic destination) {
        PersistenceAdapter adapter = this.getMatchingPersistenceAdapter(destination);
        if (adapter instanceof KahaDBPersistenceAdapter) {
            adapter.removeTopicMessageStore(destination);
            this.removeMessageStore((KahaDBPersistenceAdapter)adapter, destination);
            this.removeAll(destination);
        }
    }

    private void removeMessageStore(KahaDBPersistenceAdapter adapter, ActiveMQDestination destination) {
        if (adapter.getDestinations().isEmpty()) {
            this.stopAdapter(adapter, destination.toString());
            File adapterDir = adapter.getDirectory();
            if (adapterDir != null) {
                if (IOHelper.deleteFile(adapterDir)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.info("deleted per destination adapter directory for: " + destination);
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.info("failed to deleted per destination adapter directory for: " + destination);
                }
            }
        }
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void setBrokerName(String brokerName) {
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setBrokerName(brokerName);
        }
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setUsageManager(usageManager);
        }
    }

    @Override
    public long size() {
        long size2 = 0L;
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            size2 += persistenceAdapter.size();
        }
        return size2;
    }

    @Override
    public void start() throws Exception {
        FilteredKahaDBPersistenceAdapter filteredAdapter;
        Object result = this.chooseValue(matchAll);
        if (result != null && (filteredAdapter = (FilteredKahaDBPersistenceAdapter)result).getDestination() == matchAll && filteredAdapter.isPerDestination()) {
            this.findAndRegisterExistingAdapters(filteredAdapter);
        }
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.start();
        }
    }

    private void findAndRegisterExistingAdapters(FilteredKahaDBPersistenceAdapter template) {
        FileFilter destinationNames = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("queue#") || file.getName().startsWith("topic#");
            }
        };
        File[] candidates = template.getPersistenceAdapter().getDirectory().listFiles(destinationNames);
        if (candidates != null) {
            for (File candidate : candidates) {
                this.registerExistingAdapter(template, candidate);
            }
        }
    }

    private void registerExistingAdapter(FilteredKahaDBPersistenceAdapter filteredAdapter, File candidate) {
        KahaDBPersistenceAdapter adapter = this.adapterFromTemplate(filteredAdapter.getPersistenceAdapter(), candidate.getName());
        this.startAdapter(adapter, candidate.getName());
        Set<ActiveMQDestination> destinations = adapter.getDestinations();
        if (destinations.size() != 0) {
            this.registerAdapter(adapter, destinations.toArray(new ActiveMQDestination[0])[0]);
        } else {
            this.stopAdapter(adapter, candidate.getName());
        }
    }

    private FilteredKahaDBPersistenceAdapter addAdapter(FilteredKahaDBPersistenceAdapter filteredAdapter, ActiveMQDestination destination) {
        KahaDBPersistenceAdapter adapter = this.adapterFromTemplate(filteredAdapter.getPersistenceAdapter(), this.nameFromDestinationFilter(destination));
        return this.registerAdapter(adapter, destination);
    }

    private KahaDBPersistenceAdapter adapterFromTemplate(KahaDBPersistenceAdapter template, String destinationName) {
        KahaDBPersistenceAdapter adapter = this.kahaDBFromTemplate(template);
        this.configureAdapter(adapter);
        this.configureDirectory(adapter, destinationName);
        return adapter;
    }

    private void configureDirectory(KahaDBPersistenceAdapter adapter, String fileName) {
        File directory = null;
        directory = MessageDatabase.DEFAULT_DIRECTORY.equals(adapter.getDirectory()) ? this.getDirectory() : adapter.getDirectory();
        if (fileName != null) {
            directory = new File(directory, fileName);
        }
        adapter.setDirectory(directory);
    }

    private FilteredKahaDBPersistenceAdapter registerAdapter(KahaDBPersistenceAdapter adapter, ActiveMQDestination destination) {
        this.adapters.add(adapter);
        FilteredKahaDBPersistenceAdapter result = new FilteredKahaDBPersistenceAdapter(destination, adapter);
        this.put(destination, result);
        return result;
    }

    private void configureAdapter(KahaDBPersistenceAdapter adapter) {
        adapter.getStore().setTransactionIdTransformer(this.transactionIdTransformer);
        adapter.setBrokerService(this.getBrokerService());
    }

    private KahaDBPersistenceAdapter kahaDBFromTemplate(KahaDBPersistenceAdapter template) {
        HashMap configuration = new HashMap();
        IntrospectionSupport.getProperties(template, configuration, null);
        KahaDBPersistenceAdapter adapter = new KahaDBPersistenceAdapter();
        IntrospectionSupport.setProperties(adapter, configuration);
        return adapter;
    }

    @Override
    public void stop() throws Exception {
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.stop();
        }
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        for (KahaDBPersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setBrokerService(brokerService);
        }
        this.brokerService = brokerService;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public void setTransactionStore(MultiKahaDBTransactionStore transactionStore) {
        this.transactionStore = transactionStore;
    }

    public void setJournalMaxFileLength(int maxFileLength) {
        this.transactionStore.setJournalMaxFileLength(maxFileLength);
    }

    public int getJournalMaxFileLength() {
        return this.transactionStore.getJournalMaxFileLength();
    }

    public void setJournalWriteBatchSize(int journalWriteBatchSize) {
        this.transactionStore.setJournalMaxWriteBatchSize(journalWriteBatchSize);
    }

    public int getJournalWriteBatchSize() {
        return this.transactionStore.getJournalMaxWriteBatchSize();
    }

    public String toString() {
        String path = this.getDirectory() != null ? this.getDirectory().getAbsolutePath() : "DIRECTORY_NOT_SET";
        return "MultiKahaDBPersistenceAdapter[" + path + "]" + this.adapters;
    }
}

