/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v5;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v5.ActiveMQMessageMarshaller;

public class ActiveMQBlobMessageMarshaller
extends ActiveMQMessageMarshaller {
    @Override
    public byte getDataStructureType() {
        return 29;
    }

    @Override
    public DataStructure createObject() {
        return new ActiveMQBlobMessage();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ActiveMQBlobMessage info2 = (ActiveMQBlobMessage)o;
        info2.setRemoteBlobUrl(this.tightUnmarshalString(dataIn, bs));
        info2.setMimeType(this.tightUnmarshalString(dataIn, bs));
        info2.setDeletedByBroker(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ActiveMQBlobMessage info2 = (ActiveMQBlobMessage)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalString1(info2.getRemoteBlobUrl(), bs);
        bs.writeBoolean(info2.isDeletedByBroker());
        return (rc += this.tightMarshalString1(info2.getMimeType(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ActiveMQBlobMessage info2 = (ActiveMQBlobMessage)o;
        this.tightMarshalString2(info2.getRemoteBlobUrl(), dataOut, bs);
        this.tightMarshalString2(info2.getMimeType(), dataOut, bs);
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ActiveMQBlobMessage info2 = (ActiveMQBlobMessage)o;
        info2.setRemoteBlobUrl(this.looseUnmarshalString(dataIn));
        info2.setMimeType(this.looseUnmarshalString(dataIn));
        info2.setDeletedByBroker(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ActiveMQBlobMessage info2 = (ActiveMQBlobMessage)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalString(info2.getRemoteBlobUrl(), dataOut);
        this.looseMarshalString(info2.getMimeType(), dataOut);
        dataOut.writeBoolean(info2.isDeletedByBroker());
    }
}

