/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v6;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v6.BaseDataStreamMarshaller;

public class ProducerIdMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 123;
    }

    @Override
    public DataStructure createObject() {
        return new ProducerId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ProducerId info2 = (ProducerId)o;
        info2.setConnectionId(this.tightUnmarshalString(dataIn, bs));
        info2.setValue(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setSessionId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ProducerId info2 = (ProducerId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalString1(info2.getConnectionId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getValue(), bs);
        return (rc += this.tightMarshalLong1(wireFormat, info2.getSessionId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ProducerId info2 = (ProducerId)o;
        this.tightMarshalString2(info2.getConnectionId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getValue(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getSessionId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ProducerId info2 = (ProducerId)o;
        info2.setConnectionId(this.looseUnmarshalString(dataIn));
        info2.setValue(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setSessionId(this.looseUnmarshalLong(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ProducerId info2 = (ProducerId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalString(info2.getConnectionId(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getValue(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getSessionId(), dataOut);
    }
}

