/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usage.SystemUsage;
import org.springframework.beans.CachedIntrospectionResults;

public class XBeanBrokerService
extends BrokerService {
    private boolean start = BrokerFactory.getStartDefault();

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.shouldAutostart()) {
            this.start();
        }
    }

    @Override
    protected boolean shouldAutostart() {
        return this.start;
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
        if (usage.getJobSchedulerUsage().getStore() == null) {
            usage.getJobSchedulerUsage().setStore(this.getJobSchedulerStore());
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.stop();
    }

    @Override
    public void stop() throws Exception {
        CachedIntrospectionResults.clearClassLoader((ClassLoader)this.getClass().getClassLoader());
        super.stop();
    }

    public void setStart(boolean start2) {
        this.start = start2;
    }
}

