/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.camel.CamelDestination;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;

public class CamelMessageConsumer
implements MessageConsumer {
    private final CamelDestination destination;
    private final Endpoint endpoint;
    private final ActiveMQSession session;
    private final String messageSelector;
    private final boolean noLocal;
    private MessageListener messageListener;
    private Consumer consumer;
    private PollingConsumer pollingConsumer;
    private boolean closed;

    public CamelMessageConsumer(CamelDestination destination, Endpoint endpoint, ActiveMQSession session, String messageSelector, boolean noLocal) {
        this.destination = destination;
        this.endpoint = endpoint;
        this.session = session;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
    }

    @Override
    public void close() throws JMSException {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.consumer != null) {
                    this.consumer.stop();
                }
                if (this.pollingConsumer != null) {
                    this.pollingConsumer.stop();
                }
            }
            catch (JMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.messageListener = messageListener;
        if (messageListener != null && this.consumer == null) {
            this.consumer = this.createConsumer();
        }
    }

    @Override
    public Message receive() throws JMSException {
        Exchange exchange = this.getPollingConsumer().receive();
        return this.createMessage(exchange);
    }

    @Override
    public Message receive(long timeoutMillis) throws JMSException {
        Exchange exchange = this.getPollingConsumer().receive(timeoutMillis);
        return this.createMessage(exchange);
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        Exchange exchange = this.getPollingConsumer().receiveNoWait();
        return this.createMessage(exchange);
    }

    public CamelDestination getDestination() {
        return this.destination;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getMessageSelector() {
        return this.messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public ActiveMQSession getSession() {
        return this.session;
    }

    protected PollingConsumer getPollingConsumer() throws JMSException {
        try {
            if (this.pollingConsumer == null) {
                this.pollingConsumer = this.endpoint.createPollingConsumer();
                this.pollingConsumer.start();
            }
            return this.pollingConsumer;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    protected Message createMessage(Exchange exchange) throws JMSException {
        if (exchange != null) {
            Message message = this.destination.getBinding().makeJmsMessage(exchange, (Session)this.session);
            return message;
        }
        return null;
    }

    protected Consumer createConsumer() throws JMSException {
        try {
            Consumer answer = this.endpoint.createConsumer(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    Message message = CamelMessageConsumer.this.createMessage(exchange);
                    CamelMessageConsumer.this.getMessageListener().onMessage(message);
                }
            });
            answer.start();
            return answer;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The producer is closed");
        }
    }
}

