/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.activemq.karaf.audit;

import org.apache.activemq.broker.util.AuditLog;
import org.apache.activemq.broker.util.AuditLogFactory;
import org.apache.activemq.broker.util.AuditLogService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventConstants;
import org.osgi.service.event.EventHandler;

import java.util.Dictionary;
import java.util.Hashtable;

public class Activator implements BundleActivator {

    AuditLogService auditLogService;

    public static String EVENT_TOPIC = "org/fusesource/audit";

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        auditLogService = AuditLogService.getAuditLog();
        AuditLogFactory factory = new OsgiAuditLogFactory(bundleContext);
        auditLogService.setFactory(factory);

        EventAdminAuditLog auditLog = new EventAdminAuditLog();
        ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class.getName());
        if (ref != null) {
            EventAdmin eventAdmin = (EventAdmin) bundleContext.getService(ref);
            auditLog.setEventAdmin(eventAdmin);
        }
        bundleContext.registerService(AuditLog.class.getName(), auditLog, null);

        // register default handler
        Dictionary topic = new Hashtable();
        topic.put(EventConstants.EVENT_TOPIC, EVENT_TOPIC);
        bundleContext.registerService(EventHandler.class.getName(), new DefaultAuditLogHandler(), topic);
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
    }

}