/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.activemq.karaf.audit;

import org.apache.activemq.broker.util.AuditLog;
import org.apache.activemq.broker.util.AuditLogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OsgiAuditLogFactory implements AuditLogFactory {

    BundleContext context;
    ServiceTracker tracker;

    public OsgiAuditLogFactory(BundleContext context) {
        this.context = context;
        tracker = new ServiceTracker(context, AuditLog.class.getName(), null);
        tracker.open();
    }

    @Override
    public List<AuditLog> getAuditLogs() {
        Object[] logServices = tracker.getServices();
        if (logServices != null) {
            List logs =  Arrays.asList(logServices);
            return logs;
        } else {
            return Collections.emptyList();
        }
    }
}
