/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.TopicReferenceStore;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRef;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRefMarshaller;
import org.apache.activemq.store.kahadaptor.KahaReferenceStore;
import org.apache.activemq.store.kahadaptor.KahaReferenceStoreAdapter;
import org.apache.activemq.store.kahadaptor.ReferenceRecord;
import org.apache.activemq.store.kahadaptor.TopicSubAck;
import org.apache.activemq.store.kahadaptor.TopicSubContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaTopicReferenceStore
extends KahaReferenceStore
implements TopicReferenceStore {
    private static final Log LOG = LogFactory.getLog(KahaTopicReferenceStore.class);
    protected ListContainer<TopicSubAck> ackContainer;
    protected Map<String, TopicSubContainer> subscriberMessages = new ConcurrentHashMap<String, TopicSubContainer>();
    private MapContainer<String, SubscriptionInfo> subscriberContainer;
    private Store store;
    private static final String TOPIC_SUB_NAME = "tsn";

    public KahaTopicReferenceStore(Store store, KahaReferenceStoreAdapter adapter, MapContainer<MessageId, ReferenceRecord> messageContainer, ListContainer<TopicSubAck> ackContainer, MapContainer<String, SubscriptionInfo> subsContainer, ActiveMQDestination destination) throws IOException {
        super(adapter, messageContainer, destination);
        this.store = store;
        this.ackContainer = ackContainer;
        this.subscriberContainer = subsContainer;
        for (SubscriptionInfo info : this.subscriberContainer.values()) {
            this.addSubscriberMessageContainer(info.getClientId(), info.getSubscriptionName());
        }
    }

    @Override
    public void dispose(ConnectionContext context) {
        super.dispose(context);
        this.subscriberContainer.delete();
    }

    @Override
    protected MessageId getMessageId(Object object) {
        return new MessageId(((ReferenceRecord)object).getMessageId());
    }

    @Override
    public void addMessage(ConnectionContext context, Message message) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    @Override
    public Message getMessage(MessageId identity) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMessageReference(ConnectionContext context, MessageId messageId, ReferenceStore.ReferenceData data) {
        boolean uniqueReferenceAdded = false;
        this.lock.lock();
        try {
            ReferenceRecord record = new ReferenceRecord(messageId.toString(), data);
            int subscriberCount = this.subscriberMessages.size();
            if (subscriberCount > 0 && !this.isDuplicate(messageId)) {
                StoreEntry messageEntry = this.messageContainer.place(messageId, record);
                this.addInterest(record);
                uniqueReferenceAdded = true;
                TopicSubAck tsa = new TopicSubAck();
                tsa.setCount(subscriberCount);
                tsa.setMessageEntry(messageEntry);
                StoreEntry ackEntry = this.ackContainer.placeLast(tsa);
                for (TopicSubContainer container : this.subscriberMessages.values()) {
                    ConsumerMessageRef ref = new ConsumerMessageRef();
                    ref.setAckEntry(ackEntry);
                    ref.setMessageEntry(messageEntry);
                    ref.setMessageId(messageId);
                    container.add(ref);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.destination.getPhysicalName() + " add reference: " + messageId));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return uniqueReferenceAdded;
    }

    @Override
    public ReferenceStore.ReferenceData getMessageReference(MessageId identity) throws IOException {
        ReferenceRecord result = (ReferenceRecord)this.messageContainer.get(identity);
        if (result == null) {
            return null;
        }
        return result.getData();
    }

    public void addReferenceFileIdsInUse() {
        StoreEntry entry = this.ackContainer.getFirst();
        while (entry != null) {
            TopicSubAck subAck = this.ackContainer.get(entry);
            if (subAck.getCount() > 0) {
                ReferenceRecord rr = (ReferenceRecord)this.messageContainer.getValue(subAck.getMessageEntry());
                this.addInterest(rr);
            }
            entry = this.ackContainer.getNext(entry);
        }
    }

    protected MapContainer addSubscriberMessageContainer(String clientId, String subscriptionName) throws IOException {
        String containerName = this.getSubscriptionContainerName(this.getSubscriptionKey(clientId, subscriptionName));
        MapContainer container = this.store.getMapContainer(containerName, containerName);
        container.setKeyMarshaller(Store.MESSAGEID_MARSHALLER);
        ConsumerMessageRefMarshaller marshaller = new ConsumerMessageRefMarshaller();
        container.setValueMarshaller(marshaller);
        TopicSubContainer tsc = new TopicSubContainer(container);
        this.subscriberMessages.put(this.getSubscriptionKey(clientId, subscriptionName), tsc);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acknowledgeReference(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        boolean removeMessage = false;
        this.lock.lock();
        try {
            String key = this.getSubscriptionKey(clientId, subscriptionName);
            TopicSubContainer container = this.subscriberMessages.get(key);
            if (container != null) {
                ConsumerMessageRef ref = null;
                ref = container.remove(messageId);
                if (ref != null) {
                    StoreEntry entry = ref.getAckEntry();
                    TopicSubAck tsa = this.ackContainer.get(entry = this.ackContainer.refresh(entry));
                    if (tsa != null) {
                        if (tsa.decrementCount() <= 0) {
                            this.ackContainer.remove(entry);
                            ReferenceRecord rr = (ReferenceRecord)this.messageContainer.get(messageId);
                            if (rr != null) {
                                entry = tsa.getMessageEntry();
                                entry = this.messageContainer.refresh(entry);
                                this.messageContainer.remove(entry);
                                this.removeInterest(rr);
                                removeMessage = true;
                                this.dispatchAudit.isDuplicate(messageId);
                            }
                        } else {
                            this.ackContainer.update(entry, tsa);
                        }
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this.destination.getPhysicalName() + " remove: " + messageId));
                    }
                } else if (this.ackContainer.isEmpty() || this.subscriberMessages.size() == 1 || this.isUnreferencedBySubscribers(key, this.subscriberMessages, messageId)) {
                    removeMessage = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.destination.getPhysicalName() + " remove with no outstanding reference (dup ack): " + messageId));
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return removeMessage;
    }

    private boolean isUnreferencedBySubscribers(String key, Map<String, TopicSubContainer> subscriberContainers, MessageId messageId) {
        boolean isUnreferenced = true;
        block0: for (Map.Entry<String, TopicSubContainer> entry : subscriberContainers.entrySet()) {
            if (key.equals(entry.getKey()) || entry.getValue().isEmpty()) continue;
            TopicSubContainer container = entry.getValue();
            Iterator i = container.iterator();
            while (i.hasNext()) {
                ConsumerMessageRef ref = (ConsumerMessageRef)i.next();
                if (!messageId.equals(ref.getMessageId())) continue;
                isUnreferenced = false;
                continue block0;
            }
        }
        return isUnreferenced;
    }

    @Override
    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        this.acknowledgeReference(context, clientId, subscriptionName, messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubsciption(SubscriptionInfo info, boolean retroactive) throws IOException {
        String key = this.getSubscriptionKey(info.getClientId(), info.getSubscriptionName());
        this.lock.lock();
        try {
            if (!this.subscriberContainer.containsKey(key)) {
                this.subscriberContainer.put(key, info);
                this.adapter.addSubscriberState(info);
            }
            this.addSubscriberMessageContainer(info.getClientId(), info.getSubscriptionName());
            if (retroactive) {
                // empty if block
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        this.lock.lock();
        try {
            SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
            if (info != null) {
                this.adapter.removeSubscriberState(info);
            }
            this.removeSubscriberMessageContainer(clientId, subscriptionName);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        SubscriptionInfo[] result = this.subscriberContainer.values().toArray(new SubscriptionInfo[this.subscriberContainer.size()]);
        return result;
    }

    @Override
    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriberName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        return container != null ? container.size() : 0;
    }

    @Override
    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.subscriberContainer.get(this.getSubscriptionKey(clientId, subscriptionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        block9: {
            String key = this.getSubscriptionKey(clientId, subscriptionName);
            this.lock.lock();
            try {
                TopicSubContainer container = this.subscriberMessages.get(key);
                if (container == null) break block9;
                int count = 0;
                StoreEntry entry = container.getBatchEntry();
                if (entry == null) {
                    entry = container.getEntry();
                } else if ((entry = container.refreshEntry(entry)) != null) {
                    entry = container.getNextEntry(entry);
                }
                if (entry == null) break block9;
                do {
                    ConsumerMessageRef consumerRef;
                    ReferenceRecord msg;
                    if ((msg = (ReferenceRecord)this.messageContainer.getValue((consumerRef = container.get(entry)).getMessageEntry())) != null) {
                        if (this.recoverReference(listener, msg)) {
                            ++count;
                            container.setBatchEntry(msg.getMessageId(), entry);
                            continue;
                        }
                        break;
                    }
                    container.reset();
                } while ((entry = container.getNextEntry(entry)) != null && count < maxReturned && listener.hasSpace());
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        block1: {
            ConsumerMessageRef ref;
            ReferenceRecord msg;
            String key = this.getSubscriptionKey(clientId, subscriptionName);
            TopicSubContainer container = this.subscriberMessages.get(key);
            if (container == null) break block1;
            Iterator i = container.iterator();
            while (i.hasNext() && ((msg = (ReferenceRecord)this.messageContainer.getValue((ref = (ConsumerMessageRef)i.next()).getMessageEntry())) == null || this.recoverReference(listener, msg))) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetBatching(String clientId, String subscriptionName) {
        this.lock.lock();
        try {
            String key = this.getSubscriptionKey(clientId, subscriptionName);
            TopicSubContainer topicSubContainer = this.subscriberMessages.get(key);
            if (topicSubContainer != null) {
                topicSubContainer.reset();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.lock.lock();
        try {
            HashSet<String> tmpSet = new HashSet<String>(this.subscriberContainer.keySet());
            for (String key : tmpSet) {
                TopicSubContainer container = this.subscriberMessages.get(key);
                if (container == null) continue;
                container.clear();
            }
            this.ackContainer.clear();
        }
        finally {
            this.lock.unlock();
        }
        super.removeAllMessages(context);
    }

    protected void removeSubscriberMessageContainer(String clientId, String subscriptionName) throws IOException {
        String subscriberKey = this.getSubscriptionKey(clientId, subscriptionName);
        String containerName = this.getSubscriptionContainerName(subscriberKey);
        this.subscriberContainer.remove(subscriberKey);
        TopicSubContainer container = this.subscriberMessages.remove(subscriberKey);
        if (container != null) {
            Iterator i = container.iterator();
            while (i.hasNext()) {
                TopicSubAck tsa;
                ConsumerMessageRef ref = (ConsumerMessageRef)i.next();
                if (ref == null || (tsa = this.ackContainer.get(ref.getAckEntry())) == null) continue;
                if (tsa.decrementCount() <= 0) {
                    this.ackContainer.remove(ref.getAckEntry());
                    this.messageContainer.remove(tsa.getMessageEntry());
                    continue;
                }
                this.ackContainer.update(ref.getAckEntry(), tsa);
            }
        }
        this.store.deleteMapContainer(containerName, containerName);
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(clientId).append(":");
        String name = subscriberName != null ? subscriberName : "NOT_SET";
        return buffer.append(name).toString();
    }

    private String getSubscriptionContainerName(String subscriptionKey) {
        StringBuffer result = new StringBuffer(TOPIC_SUB_NAME);
        result.append(this.destination.getQualifiedName());
        result.append(subscriptionKey);
        return result.toString();
    }
}

