/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.impl.scan.AnnotatedWithAnyPackageScanFilter;
import org.apache.camel.impl.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.CompositePackageScanFilter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPackageScanClassResolver
implements PackageScanClassResolver {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private Set<ClassLoader> classLoaders;
    private Set<PackageScanFilter> scanFilters;

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        this.getClassLoaders().add(classLoader);
    }

    @Override
    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new HashSet<ClassLoader>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("The thread context class loader: " + ccl + "  is used to load the class"));
                }
                this.classLoaders.add(ccl);
            }
            this.classLoaders.add(DefaultPackageScanClassResolver.class.getClassLoader());
        }
        return this.classLoaders;
    }

    @Override
    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    @Override
    public Set<Class<?>> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Searching for annotations of " + annotation.getName() + " in packages: " + Arrays.asList(packageNames)));
        }
        PackageScanFilter test = this.getCompositeFilter(new AnnotatedWithPackageScanFilter(annotation, true));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    @Override
    public Set<Class<?>> findAnnotated(Set<Class<? extends Annotation>> annotations, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Searching for annotations of " + annotations + " in packages: " + Arrays.asList(packageNames)));
        }
        PackageScanFilter test = this.getCompositeFilter(new AnnotatedWithAnyPackageScanFilter(annotations, true));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    public Set<Class<?>> findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames)));
        }
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    @Override
    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.find(test, packageName, classLoader, classes);
        }
    }

    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration<URL> urls;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Searching for: " + test + " in package: " + packageName + " using classloader: " + loader.getClass().getName()));
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.trace((Object)"No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Cannot read package: " + packageName), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                File file;
                url = urls.nextElement();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("URL from classloader: " + url));
                }
                String urlPath = url.getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Decoded urlPath: " + urlPath + " with protocol: " + url.getProtocol()));
                }
                if (urlPath.startsWith("file:")) {
                    try {
                        urlPath = new URI(url.getFile()).getPath();
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    this.log.trace((Object)"It's a virtual osgi bundle, skipping");
                    continue;
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Scanning for classes in [" + urlPath + "] matching criteria: " + test));
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Loading from directory using file: " + file));
                    }
                    this.loadImplementationsInDirectory(test, packageName, file, classes);
                    continue;
                }
                if (urlPath.startsWith("http:")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Loading from jar using http/https: " + urlPath));
                    }
                    URL urlStream = new URL(urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Loading from jar using file: " + file));
                    }
                    stream = new FileInputStream(file);
                }
                this.loadImplementationsInJar(test, packageName, stream, urlPath, classes);
            }
            catch (IOException e) {
                this.log.debug((Object)("Cannot read entries in url: " + url), (Throwable)e);
            }
        }
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting resource URL for package: " + packageName + " with classloader: " + loader));
        }
        if (!packageName.endsWith("/")) {
            packageName = packageName + "/";
        }
        return loader.getResources(packageName);
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }

    private void loadImplementationsInDirectory(PackageScanFilter test, String parent, File location, Set<Class<?>> classes) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            String name = file.getName();
            if (name == null) continue;
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file, classes);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass, classes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplementationsInJar(PackageScanFilter test, String parent, InputStream stream, String urlPath, Set<Class<?>> classes) {
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name == null) continue;
                name = name.trim();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.addIfMatching(test, name, classes);
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Cannot search jar file '" + urlPath + "' for classes matching criteria: " + test + " due to an IOException: " + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            ObjectHelper.close(jarStream, urlPath, this.log);
        }
    }

    protected void addIfMatching(PackageScanFilter test, String fqn, Set<Class<?>> classes) {
        block11: {
            try {
                String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
                Set<ClassLoader> set = this.getClassLoaders();
                boolean found = false;
                for (ClassLoader classLoader : set) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Testing for class " + externalName + " matches criteria [" + test + "] using classloader:" + classLoader));
                    }
                    try {
                        Class<?> type = classLoader.loadClass(externalName);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Loaded the class: " + type + " in classloader: " + classLoader));
                        }
                        if (test.matches(type)) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("Found class: " + type + " which matches the filter in classloader: " + classLoader));
                            }
                            classes.add(type);
                        }
                        found = true;
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)("Cannot find class '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e), (Throwable)e);
                    }
                    catch (NoClassDefFoundError e) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)("Cannot find the class definition '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e), (Throwable)e);
                    }
                }
                if (!found && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cannot find class '" + fqn + "' in any classloaders: " + set));
                }
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block11;
                this.log.warn((Object)("Cannot examine class '" + fqn + "' due to a " + e.getClass().getName() + " with message: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

