/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingSlip
extends ServiceSupport
implements Processor,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(RoutingSlip.class);
    private ProducerCache producerCache;
    private final String header;
    private final String uriDelimiter;

    public RoutingSlip(String header) {
        this(header, ",");
    }

    public RoutingSlip(String header, String uriDelimiter) {
        ObjectHelper.notNull(header, "header");
        ObjectHelper.notNull(uriDelimiter, "uriDelimiter");
        this.header = header;
        this.uriDelimiter = uriDelimiter;
    }

    public String toString() {
        return "RoutingSlip[header=" + this.header + " uriDelimiter=" + this.uriDelimiter + "]";
    }

    public String getTraceLabel() {
        return "routingSlip[" + this.header + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        String[] recipients = this.recipients(message);
        Exchange current = exchange;
        for (String nextRecipient : recipients) {
            Endpoint endpoint = this.resolveEndpoint(exchange, nextRecipient);
            DefaultExchange copy = new DefaultExchange(current);
            this.updateRoutingSlip(current);
            this.copyOutToIn(copy, current);
            try {
                this.getProducerCache(exchange).doInProducer(endpoint, copy, null, new ProducerCallback<Object>(){

                    @Override
                    public Object doInProducer(Producer producer, Exchange exchange, ExchangePattern exchangePattern) throws Exception {
                        exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
                        producer.process(exchange);
                        return exchange;
                    }
                });
            }
            catch (Exception e) {
                copy.setException(e);
            }
            finally {
                current = copy;
            }
            boolean exceptionHandled = RoutingSlip.hasExceptionBeenHandledByErrorHandler(current);
            if (!current.isFailed() && !current.isRollbackOnly() && !exceptionHandled) continue;
            if (!LOG.isDebugEnabled()) break;
            StringBuilder sb = new StringBuilder();
            sb.append("Message exchange has failed so breaking out of the routing slip: ").append(current);
            if (current.isRollbackOnly()) {
                sb.append(" Marked as rollback only.");
            }
            if (current.getException() != null) {
                sb.append(" Exception: ").append(current.getException());
            }
            if (current.hasOut() && current.getOut().isFault()) {
                sb.append(" Fault: ").append(current.getOut());
            }
            if (exceptionHandled) {
                sb.append(" Handled by the error handler.");
            }
            LOG.debug((Object)sb.toString());
            break;
        }
        ExchangeHelper.copyResults(exchange, current);
    }

    private static boolean hasExceptionBeenHandledByErrorHandler(Exchange nextExchange) {
        return Boolean.TRUE.equals(nextExchange.getProperty("CamelErrorHandlerHandled"));
    }

    protected ProducerCache getProducerCache(Exchange exchange) throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(exchange.getContext());
            this.producerCache.start();
        }
        return this.producerCache;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected void doStart() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.stop();
        }
    }

    private void updateRoutingSlip(Exchange current) {
        Message message = this.getResultMessage(current);
        String oldSlip = message.getHeader(this.header, String.class);
        if (oldSlip != null) {
            int delimiterIndex = oldSlip.indexOf(this.uriDelimiter);
            String newSlip = delimiterIndex > 0 ? oldSlip.substring(delimiterIndex + 1) : "";
            message.setHeader(this.header, newSlip);
        }
    }

    private Message getResultMessage(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private String[] recipients(Message message) {
        Object headerValue = message.getHeader(this.header);
        if (headerValue != null && !headerValue.equals("")) {
            return headerValue.toString().split(this.uriDelimiter);
        }
        return new String[0];
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException(source.getException());
        if (source.hasOut() && source.getOut().isFault()) {
            result.getOut().copyFrom(source.getOut());
        }
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }
}

