/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendProcessor
extends ServiceSupport
implements Processor,
Traceable {
    protected static final transient Log LOG = LogFactory.getLog(SendProcessor.class);
    protected ProducerCache producerCache;
    protected Endpoint destination;
    protected ExchangePattern pattern;
    private boolean init;

    public SendProcessor(Endpoint destination) {
        ObjectHelper.notNull(destination, "destination");
        this.destination = destination;
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        this(destination);
        this.pattern = pattern;
    }

    public String toString() {
        return "sendTo(" + this.destination + (this.pattern != null ? " " + (Object)((Object)this.pattern) : "") + ")";
    }

    public synchronized void setDestination(Endpoint destination) {
        this.destination = destination;
        this.init = false;
    }

    public String getTraceLabel() {
        return this.destination.getEndpointUri();
    }

    public void process(Exchange exchange) throws Exception {
        if (!this.init) {
            this.init = true;
            Endpoint lookup = exchange.getContext().hasEndpoint(this.destination.getEndpointKey());
            if (lookup instanceof InterceptSendToEndpoint) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SendTo is intercepted using a interceptSendToEndpoint: " + lookup.getEndpointUri()));
                }
                this.destination = lookup;
            }
        }
        this.doProcess(exchange);
    }

    public Exchange doProcess(Exchange exchange) throws Exception {
        return this.getProducerCache(exchange).doInProducer(this.destination, exchange, this.pattern, new ProducerCallback<Exchange>(){

            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                exchange = SendProcessor.this.configureExchange(exchange, pattern);
                producer.process(exchange);
                return exchange;
            }
        });
    }

    protected ProducerCache getProducerCache(Exchange exchange) throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(exchange.getContext());
            this.producerCache.start();
        }
        return this.producerCache;
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        return exchange;
    }

    protected void doStart() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.stop();
        }
    }
}

