/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed JMS Temporay Topic Endpoint")
public class JmsTemporaryTopicEndpoint
extends JmsEndpoint
implements DestinationEndpoint {
    private Destination jmsDestination;

    public JmsTemporaryTopicEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        super(uri, component, destination, true, configuration);
    }

    public JmsTemporaryTopicEndpoint(String endpointUri, String destination) {
        super(endpointUri, destination);
    }

    public JmsTemporaryTopicEndpoint(TemporaryTopic jmsDestination) throws JMSException {
        super("jms:temp:topic:" + jmsDestination.getTopicName(), null);
        this.jmsDestination = jmsDestination;
        this.setDestination((Destination)jmsDestination);
    }

    public boolean isSingleton() {
        return true;
    }

    public synchronized Destination getJmsDestination(Session session) throws JMSException {
        if (this.jmsDestination == null) {
            this.jmsDestination = this.createJmsDestination(session);
        }
        return this.jmsDestination;
    }

    protected Destination createJmsDestination(Session session) throws JMSException {
        return session.createTemporaryTopic();
    }
}

