/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.PooledSession;
import org.apache.activemq.pool.SessionKey;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class SessionPool
implements PoolableObjectFactory {
    private ConnectionPool connectionPool;
    private SessionKey key;
    private ObjectPool sessionPool;

    public SessionPool(ConnectionPool connectionPool, SessionKey key, ObjectPool sessionPool) {
        this.connectionPool = connectionPool;
        this.key = key;
        this.sessionPool = sessionPool;
        sessionPool.setFactory((PoolableObjectFactory)this);
    }

    public void close() throws Exception {
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
        this.sessionPool = null;
    }

    public PooledSession borrowSession() throws JMSException {
        try {
            Object object = this.getSessionPool().borrowObject();
            return (PooledSession)object;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public void returnSession(PooledSession session) throws JMSException {
        this.getConnection();
        try {
            this.getSessionPool().returnObject((Object)session);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Failed to return session to pool: " + e, e);
        }
    }

    public void invalidateSession(PooledSession session) throws JMSException {
        try {
            this.getSessionPool().invalidateObject((Object)session);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Failed to invalidate session: " + e, e);
        }
    }

    public Object makeObject() throws Exception {
        return new PooledSession(this.createSession(), this);
    }

    public void destroyObject(Object o) throws Exception {
        PooledSession session = (PooledSession)o;
        session.getInternalSession().close();
    }

    public boolean validateObject(Object o) {
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }

    protected ObjectPool getSessionPool() throws AlreadyClosedException {
        if (this.sessionPool == null) {
            throw new AlreadyClosedException();
        }
        return this.sessionPool;
    }

    protected ActiveMQConnection getConnection() throws JMSException {
        return this.connectionPool.getConnection();
    }

    protected ActiveMQSession createSession() throws JMSException {
        return (ActiveMQSession)this.getConnection().createSession(this.key.isTransacted(), this.key.getAckMode());
    }
}

