/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.broker.jmx.ConnectorViewMBean;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.NetworkConnectorViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.web.BrokerFacade;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrokerFacadeSupport
implements BrokerFacade {
    public abstract ManagementContext getManagementContext();

    @Override
    public Collection<QueueViewMBean> getQueues() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getQueues();
        return this.getManagedObjects(queues, QueueViewMBean.class);
    }

    @Override
    public Collection<TopicViewMBean> getTopics() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getTopics();
        return this.getManagedObjects(queues, TopicViewMBean.class);
    }

    @Override
    public Collection<DurableSubscriptionViewMBean> getDurableTopicSubscribers() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getDurableTopicSubscribers();
        return this.getManagedObjects(queues, DurableSubscriptionViewMBean.class);
    }

    @Override
    public QueueViewMBean getQueue(String name) throws Exception {
        return (QueueViewMBean)this.getDestinationByName(this.getQueues(), name);
    }

    @Override
    public TopicViewMBean getTopic(String name) throws Exception {
        return (TopicViewMBean)this.getDestinationByName(this.getTopics(), name);
    }

    protected DestinationViewMBean getDestinationByName(Collection<? extends DestinationViewMBean> collection, String name) {
        for (DestinationViewMBean destinationViewMBean : collection) {
            if (!name.equals(destinationViewMBean.getName())) continue;
            return destinationViewMBean;
        }
        return null;
    }

    protected <T> Collection<T> getManagedObjects(ObjectName[] names, Class<T> type) {
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            Object value = this.getManagementContext().newProxyInstance(name, type, true);
            if (value == null) continue;
            answer.add(value);
        }
        return answer;
    }

    @Override
    public Collection<ConnectionViewMBean> getConnections() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connection,*");
        System.out.println(query);
        Set queryResult = this.getManagementContext().queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ConnectionViewMBean.class);
    }

    @Override
    public Collection<String> getConnections(String connectorName) throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connection,ConnectorName=" + connectorName + ",*");
        Set queryResult = this.getManagementContext().queryNames(query, null);
        ArrayList<String> result = new ArrayList<String>(queryResult.size());
        for (ObjectName on : queryResult) {
            String name = StringUtils.replace((String)on.getKeyProperty("Connection"), (String)"_", (String)":");
            result.add(name);
        }
        return result;
    }

    @Override
    public ConnectionViewMBean getConnection(String connectionName) throws Exception {
        connectionName = StringUtils.replace((String)connectionName, (String)":", (String)"_");
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connection,*,Connection=" + connectionName);
        Set queryResult = this.getManagementContext().queryNames(query, null);
        if (queryResult.size() == 0) {
            return null;
        }
        ObjectName objectName = (ObjectName)queryResult.iterator().next();
        return (ConnectionViewMBean)this.getManagementContext().newProxyInstance(objectName, ConnectionViewMBean.class, true);
    }

    @Override
    public Collection<String> getConnectors() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connector,*");
        Set queryResult = this.getManagementContext().queryNames(query, null);
        ArrayList<String> result = new ArrayList<String>(queryResult.size());
        for (ObjectName on : queryResult) {
            result.add(on.getKeyProperty("ConnectorName"));
        }
        return result;
    }

    @Override
    public ConnectorViewMBean getConnector(String name) throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName objectName = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Connector,ConnectorName=" + name);
        return (ConnectorViewMBean)this.getManagementContext().newProxyInstance(objectName, ConnectorViewMBean.class, true);
    }

    @Override
    public Collection<NetworkConnectorViewMBean> getNetworkConnectors() throws Exception {
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=NetworkConnector,*");
        Set queryResult = this.getManagementContext().queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), NetworkConnectorViewMBean.class);
    }

    @Override
    public Collection<SubscriptionViewMBean> getQueueConsumers(String queueName) throws Exception {
        String brokerName = this.getBrokerName();
        queueName = StringUtils.replace((String)queueName, (String)"\"", (String)"_");
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Subscription,destinationType=Queue,destinationName=" + queueName + ",*");
        Set queryResult = this.getManagementContext().queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class);
    }

    @Override
    public Collection<SubscriptionViewMBean> getConsumersOnConnection(String connectionName) throws Exception {
        connectionName = StringUtils.replace((String)connectionName, (String)":", (String)"_");
        String brokerName = this.getBrokerName();
        ObjectName query = new ObjectName("org.apache.activemq:BrokerName=" + brokerName + ",Type=Subscription,clientId=" + connectionName + ",*");
        Set queryResult = this.getManagementContext().queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class);
    }
}

