/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.Set;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.web.BrokerFacadeSupport;

public class LocalBrokerFacade
extends BrokerFacadeSupport {
    private BrokerService brokerService;

    public LocalBrokerFacade(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public String getBrokerName() throws Exception {
        return this.brokerService.getBrokerName();
    }

    public Broker getBroker() throws Exception {
        return this.brokerService.getBroker();
    }

    public ManagementContext getManagementContext() {
        return this.brokerService.getManagementContext();
    }

    public BrokerViewMBean getBrokerAdmin() throws Exception {
        return this.brokerService.getAdminView();
    }

    public ManagedRegionBroker getManagedBroker() throws Exception {
        BrokerView adminView = this.brokerService.getAdminView();
        if (adminView == null) {
            return null;
        }
        return adminView.getBroker();
    }

    public void purgeQueue(ActiveMQDestination destination) throws Exception {
        Set<Destination> destinations = this.getManagedBroker().getQueueRegion().getDestinations(destination);
        for (Destination dest : destinations) {
            if (!(dest instanceof Queue)) continue;
            Queue regionQueue = (Queue)dest;
            regionQueue.purge();
        }
    }
}

