/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Pattern;
import org.apache.camel.RecipientList;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private static final transient Log LOG = LogFactory.getLog(MethodInfo.class);
    private CamelContext camelContext;
    private Class<?> type;
    private Method method;
    private final List<ParameterInfo> parameters;
    private final List<ParameterInfo> bodyParameters;
    private final boolean hasCustomAnnotation;
    private final boolean hasHandlerAnnotation;
    private Expression parametersExpression;
    private ExchangePattern pattern = ExchangePattern.InOut;
    private org.apache.camel.processor.RecipientList recipientList;

    public MethodInfo(CamelContext camelContext, Class<?> type, Method method, List<ParameterInfo> parameters, List<ParameterInfo> bodyParameters, boolean hasCustomAnnotation, boolean hasHandlerAnnotation) {
        this.camelContext = camelContext;
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.bodyParameters = bodyParameters;
        this.hasCustomAnnotation = hasCustomAnnotation;
        this.hasHandlerAnnotation = hasHandlerAnnotation;
        this.parametersExpression = this.createParametersExpression();
        Pattern oneway = this.findOneWayAnnotation(method);
        if (oneway != null) {
            this.pattern = oneway.value();
        }
        if (method.getAnnotation(RecipientList.class) != null && this.matchContext(method.getAnnotation(RecipientList.class).context())) {
            RecipientList annotation = method.getAnnotation(RecipientList.class);
            this.recipientList = new org.apache.camel.processor.RecipientList(annotation.delimiter());
            this.recipientList.setStopOnException(annotation.stopOnException());
            this.recipientList.setParallelProcessing(annotation.parallelProcessoing());
            if (ObjectHelper.isNotEmpty(annotation.executorServiceRef())) {
                ExecutorService executor = CamelContextHelper.mandatoryLookup(camelContext, annotation.executorServiceRef(), ExecutorService.class);
                this.recipientList.setExecutorService(executor);
            }
            if (ObjectHelper.isNotEmpty(annotation.strategyRef())) {
                AggregationStrategy strategy = CamelContextHelper.mandatoryLookup(camelContext, annotation.strategyRef(), AggregationStrategy.class);
                this.recipientList.setAggregationStrategy(strategy);
            }
        }
    }

    private boolean matchContext(String context) {
        return !ObjectHelper.isNotEmpty(context) || this.camelContext.getName().equals(context);
    }

    public String toString() {
        return this.method.toString();
    }

    public MethodInvocation createMethodInvocation(final Object pojo, final Exchange exchange) {
        final Object[] arguments = this.parametersExpression.evaluate(exchange, Object[].class);
        return new MethodInvocation(){

            public Method getMethod() {
                return MethodInfo.this.method;
            }

            public Object[] getArguments() {
                return arguments;
            }

            public Object proceed() throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(">>>> invoking: " + MethodInfo.this.method + " on bean: " + pojo + " with arguments: " + ObjectHelper.asString(arguments) + " for exchange: " + exchange));
                }
                Object result = MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, exchange);
                if (MethodInfo.this.recipientList != null) {
                    MethodInfo.this.recipientList.sendToRecipientList(exchange, result);
                    return Void.TYPE;
                }
                return result;
            }

            public Object getThis() {
                return pojo;
            }

            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    public List<ParameterInfo> getBodyParameters() {
        return this.bodyParameters;
    }

    public Class<?> getBodyParameterType() {
        if (this.bodyParameters.isEmpty()) {
            return null;
        }
        ParameterInfo parameterInfo = this.bodyParameters.get(0);
        return parameterInfo.getType();
    }

    public boolean bodyParameterMatches(Class<?> bodyType) {
        Class<?> actualType = this.getBodyParameterType();
        return actualType != null && ObjectHelper.isAssignableFrom(bodyType, actualType);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public boolean hasBodyParameter() {
        return !this.bodyParameters.isEmpty();
    }

    public boolean hasCustomAnnotation() {
        return this.hasCustomAnnotation;
    }

    public boolean hasHandlerAnnotation() {
        return this.hasHandlerAnnotation;
    }

    public boolean isReturnTypeVoid() {
        return this.method.getReturnType().getName().equals("void");
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, Exchange exchange) throws IllegalAccessException, InvocationTargetException {
        return mth.invoke(pojo, arguments);
    }

    protected Expression createParametersExpression() {
        final int size = this.parameters.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Creating parameters expression for " + size + " parameters"));
        }
        final Expression[] expressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            Expression parameterExpression;
            expressions[i] = parameterExpression = this.parameters.get(i).getExpression();
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Parameter #" + i + " has expression: " + parameterExpression));
        }
        return new Expression(){

            /*
             * Unable to fully structure code
             */
            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                answer = new Object[size];
                body = exchange.getIn().getBody();
                multiParameterArray = false;
                if (exchange.getIn().getHeader("CamelBeanMultiParameterArray") != null) {
                    multiParameterArray = exchange.getIn().getHeader("CamelBeanMultiParameterArray", Boolean.class);
                }
                for (i = 0; i < size; ++i) {
                    value = null;
                    if (multiParameterArray) {
                        value = ((Object[])body)[i];
                    } else {
                        expression = expressions[i];
                        if (expression != null) {
                            result = expression.evaluate(exchange, Object.class);
                            if (result != null) {
                                try {
                                    value = exchange.getContext().getTypeConverter().mandatoryConvertTo(((ParameterInfo)MethodInfo.access$300(MethodInfo.this).get(i)).getType(), result);
                                    if (!MethodInfo.access$100().isTraceEnabled()) ** GOTO lbl24
                                    MethodInfo.access$100().trace((Object)("Parameter #" + i + " evaluated as: " + value + " type: " + ObjectHelper.type(value)));
                                }
                                catch (NoTypeConversionAvailableException e) {
                                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                                }
                            } else if (MethodInfo.access$100().isTraceEnabled()) {
                                MethodInfo.access$100().trace((Object)("Parameter #" + i + " evaluated as null"));
                            }
                        }
                    }
lbl24:
                    // 8 sources

                    answer[i] = value;
                }
                return (T)answer;
            }

            public String toString() {
                return "ParametersExpression: " + Arrays.asList(expressions);
            }
        };
    }

    protected Pattern findOneWayAnnotation(Method method) {
        Pattern answer = this.getPatternAnnotation(method);
        if (answer == null) {
            Class<?>[] interfaces;
            Class<?> type = method.getDeclaringClass();
            ArrayList typesToSearch = new ArrayList();
            this.addTypeAndSuperTypes(type, typesToSearch);
            for (Class<?> anInterface : interfaces = type.getInterfaces()) {
                this.addTypeAndSuperTypes(anInterface, typesToSearch);
            }
            answer = this.findOneWayAnnotationOnMethod(typesToSearch, method);
            if (answer == null) {
                answer = this.findOneWayAnnotation(typesToSearch);
            }
        }
        return answer;
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement) {
        return this.getPatternAnnotation(annotatedElement, 2);
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement, int depth) {
        Pattern answer = annotatedElement.getAnnotation(Pattern.class);
        int nextDepth = depth - 1;
        if (nextDepth > 0) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotation instanceof Pattern || annotationType.equals(annotatedElement)) continue;
                Pattern another = this.getPatternAnnotation(annotationType, nextDepth);
                if (this.pattern == null) continue;
                if (answer == null) {
                    answer = another;
                    continue;
                }
                LOG.warn((Object)("Duplicate pattern annotation: " + another + " found on annotation: " + annotation + " which will be ignored"));
            }
        }
        return answer;
    }

    protected void addTypeAndSuperTypes(Class<?> type, List<Class<?>> result) {
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            result.add(t);
        }
    }

    protected Pattern findOneWayAnnotationOnMethod(List<Class<?>> classes, Method method) {
        for (Class<?> type : classes) {
            try {
                Method definedMethod = type.getMethod(method.getName(), method.getParameterTypes());
                Pattern answer = this.getPatternAnnotation(definedMethod);
                if (answer == null) continue;
                return answer;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    protected Pattern findOneWayAnnotation(List<Class<?>> classes) {
        for (Class<?> type : classes) {
            Pattern answer = this.getPatternAnnotation(type);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    protected boolean hasExceptionParameter() {
        for (ParameterInfo parameter : this.parameters) {
            if (!Exception.class.isAssignableFrom(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ List access$300(MethodInfo x0) {
        return x0.parameters;
    }
}

