/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ManagementAware;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed Timer Endpoint")
public class TimerEndpoint
extends DefaultEndpoint
implements ManagementAware<TimerEndpoint> {
    private String timerName;
    private Date time;
    private long period = 1000L;
    private long delay;
    private boolean fixedRate;
    private boolean daemon = true;
    private Timer timer;

    public TimerEndpoint() {
    }

    public TimerEndpoint(String fullURI, TimerComponent component, String timerName) {
        super(fullURI, component);
        this.timerName = timerName;
    }

    public TimerEndpoint(String endpointUri, Timer timer) {
        this(endpointUri);
        this.timer = timer;
    }

    public TimerEndpoint(String endpointUri) {
        super(endpointUri);
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new TimerConsumer(this, processor);
    }

    @Override
    public Object getManagedObject(TimerEndpoint object) {
        return this;
    }

    @ManagedAttribute(description="Timer Name")
    public String getTimerName() {
        if (this.timerName == null) {
            this.timerName = this.getEndpointUri();
        }
        return this.timerName;
    }

    @ManagedAttribute(description="Timer Name")
    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    @ManagedAttribute(description="Timer Daemon")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(description="Timer Daemon")
    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @ManagedAttribute(description="Timer Delay")
    public long getDelay() {
        return this.delay;
    }

    @ManagedAttribute(description="Timer Delay")
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public boolean isFixedRate() {
        return this.fixedRate;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    @ManagedAttribute(description="Timer Period")
    public long getPeriod() {
        return this.period;
    }

    @ManagedAttribute(description="Timer Period")
    public void setPeriod(long period) {
        this.period = period;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    @ManagedAttribute(description="Singleton")
    public boolean isSingleton() {
        return true;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            TimerComponent tc = (TimerComponent)this.getComponent();
            this.timer = tc.getTimer(this);
        }
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @Override
    @ManagedAttribute(description="Endpoint Uri")
    public String getEndpointUri() {
        return super.getEndpointUri();
    }
}

