/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Service;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.ProxyInstantiationException;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelPostProcessorHelper
implements CamelContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelPostProcessorHelper.class);
    @XmlTransient
    private CamelContext camelContext;

    public CamelPostProcessorHelper() {
    }

    public CamelPostProcessorHelper(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean matchContext(String context) {
        return !ObjectHelper.isNotEmpty(context) || this.camelContext.getName().equals(context);
    }

    public void consumerInjection(Method method, Object bean) {
        Consume consume = method.getAnnotation(Consume.class);
        if (consume != null && this.matchContext(consume.context())) {
            LOG.info((Object)("Creating a consumer for: " + consume));
            this.subscribeMethod(method, bean, consume.uri(), consume.ref());
        }
    }

    public void subscribeMethod(Method method, Object bean, String endpointUri, String endpointName) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointName, injectionPointName, true);
        if (endpoint != null) {
            try {
                Processor processor = this.createConsumerProcessor(bean, method, endpoint);
                Consumer consumer = endpoint.createConsumer(processor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Created processor: " + processor + " for consumer: " + consumer));
                }
                this.startService(consumer);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    protected void startService(Service service) throws Exception {
        this.getCamelContext().addService(service);
    }

    protected Processor createConsumerProcessor(Object pojo, Method method, Endpoint endpoint) {
        BeanProcessor answer = new BeanProcessor(pojo, this.getCamelContext());
        answer.setMethodObject(method);
        return new UnitOfWorkProcessor(answer);
    }

    protected Endpoint getEndpointInjection(String uri, String name, String injectionPointName, boolean mandatory) {
        return CamelContextHelper.getEndpointInjection(this.getCamelContext(), uri, name, injectionPointName, mandatory);
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointRef, String injectionPointName) {
        if (type.isAssignableFrom(ProducerTemplate.class)) {
            return this.createInjectionProducerTemplate(endpointUri, endpointRef, injectionPointName);
        }
        if (type.isAssignableFrom(ConsumerTemplate.class)) {
            return this.createInjectionConsumerTemplate(endpointUri, endpointRef, injectionPointName);
        }
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointRef, injectionPointName, true);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint);
            }
            if (type.isInterface()) {
                try {
                    return ProxyHelper.createProxy(endpoint, type);
                }
                catch (Exception e) {
                    throw this.createProxyInstantiationRuntimeException(type, endpoint, e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject/@Produce for: " + endpoint);
        }
        return null;
    }

    protected ProducerTemplate createInjectionProducerTemplate(String endpointUri, String endpointRef, String injectionPointName) {
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointRef, injectionPointName, false);
        return new DefaultProducerTemplate(this.getCamelContext(), endpoint);
    }

    protected ConsumerTemplate createInjectionConsumerTemplate(String endpointUri, String endpointRef, String injectionPointName) {
        return new DefaultConsumerTemplate(this.getCamelContext());
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint) {
        try {
            PollingConsumer pollingConsumer = endpoint.createPollingConsumer();
            this.startService(pollingConsumer);
            return pollingConsumer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint) {
        try {
            Producer producer = endpoint.createProducer();
            this.startService(producer);
            return producer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
        return new ProxyInstantiationException(type, endpoint, e);
    }
}

