/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SendProcessor;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed SendProcessor")
public class ManagedSendProcessor
extends ManagedProcessor {
    private SendProcessor processor;

    public ManagedSendProcessor(CamelContext context, SendProcessor processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public SendProcessor getProcessor() {
        return this.processor;
    }

    @ManagedAttribute(description="Destination as Endpoint Uri")
    public String getDestination() {
        return this.processor.getDestination().getEndpointUri();
    }

    @ManagedAttribute(description="Message Exchange Pattern")
    public String getMessageExchangePattern() {
        if (this.processor.getPattern() != null) {
            return this.processor.getPattern().name();
        }
        return null;
    }

    @ManagedOperation(description="Change Destination Endpoint Uri")
    public void changeDestination(String uri) throws Exception {
        Endpoint endpoint = this.getContext().getEndpoint(uri);
        this.processor.setDestination(endpoint);
    }
}

