/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.MouseWheelListenerCollection;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.SourcesMouseWheelEvents;
import com.google.gwt.user.client.ui.Widget;

public class Label
extends Widget
implements SourcesClickEvents,
SourcesMouseEvents,
SourcesMouseWheelEvents,
HasHorizontalAlignment,
HasText,
HasWordWrap,
HasDirection {
    private ClickListenerCollection clickListeners;
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign;
    private MouseListenerCollection mouseListeners;
    private MouseWheelListenerCollection mouseWheelListeners;

    public static Label wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Label label = new Label(element);
        label.onAttach();
        RootPanel.detachOnWindowClose(label);
        return label;
    }

    public Label() {
        this.setElement(Document.get().createDivElement());
        this.setStyleName("gwt-Label");
    }

    public Label(String text) {
        this();
        this.setText(text);
    }

    public Label(String text, boolean wordWrap) {
        this(text);
        this.setWordWrap(wordWrap);
    }

    protected Label(Element element) {
        this.setElement(element);
        assert (element.getTagName().equalsIgnoreCase("div") || element.getTagName().equalsIgnoreCase("span"));
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
            this.sinkEvents(1);
        }
        this.clickListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
            this.sinkEvents(124);
        }
        this.mouseListeners.add(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners == null) {
            this.mouseWheelListeners = new MouseWheelListenerCollection();
            this.sinkEvents(131072);
        }
        this.mouseWheelListeners.add(listener);
    }

    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public String getText() {
        return this.getElement().getInnerText();
    }

    public boolean getWordWrap() {
        return !this.getElement().getStyle().getProperty("whiteSpace").equals("nowrap");
    }

    public void onBrowserEvent(Event event) {
        switch (event.getTypeInt()) {
            case 1: {
                if (this.clickListeners == null) break;
                this.clickListeners.fireClick(this);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 131072: {
                if (this.mouseWheelListeners == null) break;
                this.mouseWheelListeners.fireMouseWheelEvent(this, event);
            }
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(listener);
        }
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners != null) {
            this.mouseWheelListeners.remove(listener);
        }
    }

    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.getElement(), direction);
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
        this.getElement().getStyle().setProperty("textAlign", align.getTextAlignString());
    }

    public void setText(String text) {
        this.getElement().setInnerText(text);
    }

    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setProperty("whiteSpace", wrap ? "normal" : "nowrap");
    }
}

