/*
 * Decompiled with CFR 0.152.
 */
package com.iona.fuse.mb.discovery.http;

import com.iona.fuse.mb.discovery.http.DiscoveryRegistryServlet;
import com.iona.fuse.mb.discovery.http.HTTPDiscoveryAgent;
import java.net.URI;
import org.apache.activemq.Service;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;

public class EmbeddedJettyServer
implements Service {
    private HTTPDiscoveryAgent agent;
    private Server server;
    private SelectChannelConnector connector;
    private DiscoveryRegistryServlet discoveryServlet = new DiscoveryRegistryServlet();

    public void start() throws Exception {
        URI uri = new URI(this.agent.getRegistryURL());
        this.server = new Server();
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/");
        contextHandler.setServer(this.server);
        SessionHandler sessionHandler = new SessionHandler();
        contextHandler.setHandler((Handler)sessionHandler);
        ServletHandler servletHandler = new ServletHandler();
        sessionHandler.setHandler((Handler)servletHandler);
        ServletHolder holder = new ServletHolder();
        holder.setName("discoveryServlet");
        holder.setClassName(DiscoveryRegistryServlet.class.getName());
        servletHandler.setServlets(new ServletHolder[]{holder});
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("discoveryServlet");
        mapping.setPathSpec("/*");
        servletHandler.setServletMappings(new ServletMapping[]{mapping});
        this.server.setHandler((Handler)contextHandler);
        this.server.start();
        int port = 80;
        if (uri.getPort() >= 0) {
            port = uri.getPort();
        }
        this.connector = new SelectChannelConnector();
        this.connector.setPort(port);
        this.server.addConnector((Connector)this.connector);
        this.connector.start();
    }

    public void stop() throws Exception {
        if (this.connector != null) {
            this.connector.stop();
            this.connector = null;
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    public HTTPDiscoveryAgent getAgent() {
        return this.agent;
    }

    public void setAgent(HTTPDiscoveryAgent agent) {
        this.agent = agent;
    }
}

