/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransactionBroker;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.management.JMSConnectionStatsImpl;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQXAConnectionFactoryTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(ActiveMQXAConnectionFactoryTest.class);
    long txGenerator = System.currentTimeMillis();

    public void testCopy() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?");
        ActiveMQConnectionFactory copy = cf.copy();
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an ActiveMQXAConnectionFactory", (boolean)(copy instanceof ActiveMQXAConnectionFactory));
    }

    public void testUseURIToSetOptionsOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?jms.useAsyncSend=true");
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQXAConnectionFactory("vm://localhost?jms.useAsyncSend=false");
        ActiveMQXAConnectionFactoryTest.assertFalse((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQXAConnectionFactory("vm:(broker:()/localhost)?jms.useAsyncSend=true");
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm:(broker:()/localhost)", (String)cf.getBrokerURL());
    }

    public void testCreateVMConnectionWithEmbdeddBroker() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQXAConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        Connection connection = cf.createConnection();
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        connection.close();
        ActiveMQXAConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
    }

    public void testGetBrokerName() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        String brokerName = connection.getBrokerName();
        LOG.info((Object)("Got broker name: " + brokerName));
        ActiveMQXAConnectionFactoryTest.assertNotNull((String)"No broker name available!", (Object)brokerName);
        connection.close();
    }

    public void testCreateTcpConnectionUsingAllocatedPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testCreateTcpConnectionUsingKnownPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testIsSameRM() throws URISyntaxException, JMSException, XAException {
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection1 = (XAConnection)cf1.createConnection();
        XASession session1 = connection1.createXASession();
        XAResource resource1 = session1.getXAResource();
        ActiveMQXAConnectionFactory cf2 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection2 = (XAConnection)cf2.createConnection();
        XASession session2 = connection2.createXASession();
        XAResource resource2 = session2.getXAResource();
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)resource1.isSameRM(resource2));
        connection1.close();
        connection2.close();
    }

    public void testVanilaTransactionalProduceReceive() throws Exception {
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection1 = (XAConnection)cf1.createConnection();
        connection1.start();
        XASession session = connection1.createXASession();
        XAResource resource = session.getXAResource();
        ActiveMQQueue dest = new ActiveMQQueue(this.getName());
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(this.getName());
        producer.send((Message)message);
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session.close();
        session = connection1.createXASession();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)receivedMessage);
        ActiveMQXAConnectionFactoryTest.assertEquals((String)this.getName(), (String)receivedMessage.getText());
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
    }

    public void testConsumerCloseTransactionalSendReceive() throws Exception {
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection1 = (XAConnection)cf1.createConnection();
        connection1.start();
        XASession session = connection1.createXASession();
        XAResource resource = session.getXAResource();
        ActiveMQQueue dest = new ActiveMQQueue(this.getName());
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(this.getName());
        producer.send((Message)message);
        producer.close();
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session.close();
        session = connection1.createXASession();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        consumer.close();
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)receivedMessage);
        ActiveMQXAConnectionFactoryTest.assertEquals((String)this.getName(), (String)receivedMessage.getText());
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session = connection1.createXASession();
        consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        ActiveMQXAConnectionFactoryTest.assertNull((Object)consumer.receive(1000L));
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
    }

    public void testSessionCloseTransactionalSendReceive() throws Exception {
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection1 = (XAConnection)cf1.createConnection();
        connection1.start();
        XASession session = connection1.createXASession();
        XAResource resource = session.getXAResource();
        ActiveMQQueue dest = new ActiveMQQueue(this.getName());
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(this.getName());
        producer.send((Message)message);
        session.close();
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session = connection1.createXASession();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        session.close();
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)receivedMessage);
        ActiveMQXAConnectionFactoryTest.assertEquals((String)this.getName(), (String)receivedMessage.getText());
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session = connection1.createXASession();
        consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        ActiveMQXAConnectionFactoryTest.assertNull((Object)consumer.receive(1000L));
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
    }

    public void testReadonlyNoLeak() throws Exception {
        String brokerName = "readOnlyNoLeak";
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker:(tcp://localhost:0)/readOnlyNoLeak"));
        broker.setPersistent(false);
        broker.start();
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("failover:(" + ((TransportConnector)broker.getTransportConnectors().get(0)).getConnectUri() + ")");
        cf1.setStatsEnabled(true);
        ActiveMQXAConnection xaConnection = (ActiveMQXAConnection)cf1.createConnection();
        xaConnection.start();
        XASession session = xaConnection.createXASession();
        XAResource resource = session.getXAResource();
        Xid tid = this.createXid();
        resource.start(tid, 0);
        session.close();
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        this.assertTransactionGoneFromBroker(tid);
        this.assertTransactionGoneFromConnection("readOnlyNoLeak", xaConnection.getClientID(), xaConnection.getConnectionInfo().getConnectionId(), tid);
        this.assertSessionGone(xaConnection, session);
        this.assertTransactionGoneFromFailoverState(xaConnection, tid);
        session = xaConnection.createXASession();
        resource = session.getXAResource();
        tid = this.createXid();
        resource.start(tid, 0);
        session.close();
        resource.end(tid, 0x4000000);
        ActiveMQXAConnectionFactoryTest.assertEquals((int)3, (int)resource.prepare(tid));
        this.assertTransactionGoneFromBroker(tid);
        this.assertTransactionGoneFromConnection("readOnlyNoLeak", xaConnection.getClientID(), xaConnection.getConnectionInfo().getConnectionId(), tid);
        this.assertSessionGone(xaConnection, session);
        this.assertTransactionGoneFromFailoverState(xaConnection, tid);
        xaConnection.close();
        broker.stop();
    }

    public void testCloseSendConnection() throws Exception {
        String brokerName = "closeSend";
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker:(tcp://localhost:0)/" + brokerName));
        broker.start();
        broker.waitUntilStarted();
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory(((TransportConnector)broker.getTransportConnectors().get(0)).getConnectUri());
        XAConnection connection = (XAConnection)cf.createConnection();
        connection.start();
        XASession session = connection.createXASession();
        XAResource resource = session.getXAResource();
        ActiveMQQueue dest = new ActiveMQQueue(this.getName());
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(this.getName());
        producer.send((Message)message);
        connection.close();
        this.assertTransactionGoneFromBroker(tid);
    }

    private void assertTransactionGoneFromFailoverState(ActiveMQXAConnection connection1, Xid tid) throws Exception {
        FailoverTransport transport = (FailoverTransport)connection1.getTransport().narrow(FailoverTransport.class);
        TransactionInfo info = new TransactionInfo(connection1.getConnectionInfo().getConnectionId(), (TransactionId)new XATransactionId(tid), 2);
        ActiveMQXAConnectionFactoryTest.assertNull((String)"transaction shold not exist in the state tracker", (Object)transport.getStateTracker().processCommitTransactionOnePhase(info));
    }

    private void assertSessionGone(ActiveMQXAConnection connection1, XASession session) {
        JMSConnectionStatsImpl stats = (JMSConnectionStatsImpl)connection1.getStats();
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"should be no sessions", (int)0, (int)stats.getSessions().length);
    }

    private void assertTransactionGoneFromConnection(String brokerName, String clientId, ConnectionId connectionId, Xid tid) throws Exception {
        BrokerService broker = BrokerRegistry.getInstance().lookup(brokerName);
        CopyOnWriteArrayList connections = ((TransportConnector)broker.getTransportConnectors().get(0)).getConnections();
        for (TransportConnection connection : connections) {
            if (!connection.getConnectionId().equals(clientId)) continue;
            try {
                connection.processPrepareTransaction(new TransactionInfo(connectionId, (TransactionId)new XATransactionId(tid), 1));
                ActiveMQXAConnectionFactoryTest.fail((String)"did not get expected excepton on missing transaction, it must be still there in error!");
            }
            catch (IllegalStateException expectedOnNoTransaction) {}
        }
    }

    private void assertTransactionGoneFromBroker(Xid tid) throws Exception {
        BrokerService broker = BrokerRegistry.getInstance().lookup("localhost");
        TransactionBroker transactionBroker = (TransactionBroker)broker.getBroker().getAdaptor(TransactionBroker.class);
        try {
            transactionBroker.getTransaction(null, (TransactionId)new XATransactionId(tid), false);
            ActiveMQXAConnectionFactoryTest.fail((String)"expected exception on tx not found");
        }
        catch (XAException expectedOnNotFound) {
            // empty catch block
        }
    }

    protected void assertCreateConnection(String uri) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        TransportConnector connector = broker.addConnector(uri);
        broker.start();
        URI temp = new URI(uri);
        URI currentURI = connector.getServer().getConnectURI();
        URI connectURI = new URI(temp.getScheme(), temp.getUserInfo(), temp.getHost(), currentURI.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
        LOG.info((Object)("connection URI is: " + connectURI));
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory(connectURI);
        Connection connection = cf.createConnection();
        this.assertXAConnection(connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        connection = cf.createXAConnection();
        this.assertXAConnection(connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        broker.stop();
    }

    private void assertXAConnection(Connection connection) {
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XAConnection", (boolean)(connection instanceof XAConnection));
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XATopicConnection", (boolean)(connection instanceof XATopicConnection));
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XAQueueConnection", (boolean)(connection instanceof XAQueueConnection));
    }

    public Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(++this.txGenerator);
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            public int getFormatId() {
                return 86;
            }

            public byte[] getGlobalTransactionId() {
                return bs;
            }

            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }
}

