/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;

public class ExclusiveConsumerStartupDestinationTest
extends EmbeddedBrokerTestSupport {
    private static final String VM_BROKER_URL = "vm://localhost";

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        PolicyMap map = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        entry.setAllConsumersExclusiveByDefault(true);
        map.setDefaultEntry(entry);
        answer.setDestinationPolicy(map);
        return answer;
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/exclusive-consumer-startup-destination.xml";
    }

    private Connection createConnection(boolean start) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(VM_BROKER_URL);
        Connection conn = cf.createConnection();
        if (start) {
            conn.start();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExclusiveConsumerSelectedCreatedFirst() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE1");
            MessageConsumer exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE1");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE1");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailoverToAnotherExclusiveConsumerCreatedFirst() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession1 = null;
        Session exclusiveSession2 = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession1 = conn.createSession(false, 1);
            exclusiveSession2 = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE2");
            MessageConsumer exclusiveConsumer1 = exclusiveSession1.createConsumer((Destination)exclusiveQueue);
            MessageConsumer exclusiveConsumer2 = exclusiveSession2.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE2");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE2");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer1.receive(100L));
            Assert.assertNull((Object)exclusiveConsumer2.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer1.close();
            producer.send((Message)msg);
            producer.send((Message)msg);
            Assert.assertNotNull((String)"Should have received a message", (Object)exclusiveConsumer2.receive(100L));
            Assert.assertNull((String)"Should not have received a message", (Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailoverToNonExclusiveConsumer() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE3");
            MessageConsumer exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE3");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE3");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer.close();
            producer.send((Message)msg);
            Assert.assertNotNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }
}

