/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerDestinationStoreLimitTest
extends JmsTestSupport {
    static final Log LOG = LogFactory.getLog(PerDestinationStoreLimitTest.class);
    final String oneKb = new String(new byte[1024]);
    ActiveMQDestination queueDest = new ActiveMQQueue("PerDestinationStoreLimitTest.Queue");
    ActiveMQDestination topicDest = new ActiveMQTopic("PerDestinationStoreLimitTest.Topic");
    protected TransportConnector connector;
    protected ActiveMQConnection connection;

    public void testDLQAfterBlockTopic() throws Exception {
        this.doTestDLQAfterBlock(this.topicDest);
    }

    public void testDLQAfterBlockQueue() throws Exception {
        this.doTestDLQAfterBlock(this.queueDest);
    }

    public void doTestDLQAfterBlock(ActiveMQDestination destination) throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setMaximumRedeliveries(0);
        factory.setRedeliveryPolicy(redeliveryPolicy);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.setClientID("someId");
        this.connection.start();
        Session consumerSession = this.connection.createSession(true, 0);
        MessageConsumer consumer = destination.isQueue() ? consumerSession.createConsumer((Destination)destination) : consumerSession.createDurableSubscriber((Topic)destination, "Durable");
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        final Session session = this.connection.createSession(true, 0);
        final MessageProducer producer = session.createProducer((Destination)destination);
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        final CountDownLatch fillerStarted = new CountDownLatch(1);
        final AtomicLong sent = new AtomicLong(0L);
        Thread thread = new Thread("Filler"){
            int i;

            public void run() {
                while (keepGoing.get()) {
                    done.set(false);
                    fillerStarted.countDown();
                    try {
                        producer.send((Message)session.createTextMessage(PerDestinationStoreLimitTest.this.oneKb + ++this.i));
                        if (this.i % 10 == 0) {
                            session.commit();
                            sent.getAndAdd(10L);
                            LOG.info((Object)("committed/sent: " + sent.get()));
                        }
                        LOG.info((Object)("sent: " + this.i));
                    }
                    catch (JMSException jMSException) {}
                }
            }
        };
        thread.start();
        PerDestinationStoreLimitTest.assertTrue((String)"filler started..", (boolean)fillerStarted.await(20L, TimeUnit.SECONDS));
        this.waitForBlocked(done);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        int received = 0;
        while ((long)received < sent.get()) {
            TextMessage msg = (TextMessage)consumer.receive(4000L);
            if (msg == null) {
                LOG.info((Object)("received null on count: " + received));
                break;
            }
            LOG.info((Object)("received: " + received + ", msg: " + msg.getJMSMessageID()));
            if (received % 5 == 0) {
                if (received % 3 == 0) {
                    LOG.info((Object)("rollback on : " + received));
                    consumerSession.rollback();
                } else {
                    LOG.info((Object)("commit on : " + received));
                    consumerSession.commit();
                }
            }
            ++received;
        }
        LOG.info((Object)("Done:: sent: " + sent.get() + ", received: " + received));
        keepGoing.set(false);
        PerDestinationStoreLimitTest.assertTrue((String)"some were sent:", (sent.get() > 0L ? 1 : 0) != 0);
        PerDestinationStoreLimitTest.assertEquals((String)"received what was committed", (long)sent.get(), (long)received);
    }

    protected void waitForBlocked(AtomicBoolean done) throws InterruptedException {
        while (true) {
            Thread.sleep(1000L);
            if (done.get()) break;
            done.set(true);
        }
        LOG.info((Object)"Blocked....");
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setDeleteAllMessagesOnStartup(true);
        service.setUseJmx(false);
        service.getSystemUsage().getStoreUsage().setLimit(204800L);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setStoreUsageHighWaterMark(50);
        policyMap.put(this.queueDest, (Object)policy);
        policyMap.put(this.topicDest, (Object)policy);
        service.setDestinationPolicy(policyMap);
        this.connector = service.addConnector("tcp://localhost:0");
        return service;
    }

    public void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            TcpTransport t = (TcpTransport)this.connection.getTransport().narrow(TcpTransport.class);
            t.getTransportListener().onException(new IOException("Disposed."));
            this.connection.getTransport().stop();
            super.tearDown();
        }
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connector.getConnectUri());
    }
}

