/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.Vector;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempQueueMemoryTest
extends EmbeddedBrokerTestSupport {
    protected Connection serverConnection;
    protected Session serverSession;
    protected Connection clientConnection;
    protected Session clientSession;
    protected Destination serverDestination;
    protected int messagesToSend = 2000;
    protected boolean deleteTempQueue = true;
    protected boolean serverTransactional = false;
    protected boolean clientTransactional = false;
    protected int numConsumers = 1;
    protected int numProducers = 1;

    public void testConcurrentProducerRequestReply() throws Exception {
        this.numProducers = 10;
        this.testLoadRequestReply();
    }

    public void testLoadRequestReply() throws Exception {
        for (int i = 0; i < this.numConsumers; ++i) {
            this.serverSession.createConsumer(this.serverDestination).setMessageListener(new MessageListener(){

                public void onMessage(Message msg) {
                    try {
                        Destination replyTo = msg.getJMSReplyTo();
                        MessageProducer producer = TempQueueMemoryTest.this.serverSession.createProducer(replyTo);
                        producer.send(replyTo, msg);
                        if (TempQueueMemoryTest.this.serverTransactional) {
                            TempQueueMemoryTest.this.serverSession.commit();
                        }
                        producer.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        Vector<Thread> threads = new Vector<Thread>(this.numProducers);
        for (int i = 0; i < this.numProducers; ++i) {
            class Producer
            extends Thread {
                private int numToSend;

                public Producer(int numToSend) {
                    this.numToSend = numToSend;
                }

                public void run() {
                    try {
                        Session session = TempQueueMemoryTest.this.clientConnection.createSession(TempQueueMemoryTest.this.clientTransactional, TempQueueMemoryTest.this.clientTransactional ? 0 : 1);
                        MessageProducer producer = session.createProducer(TempQueueMemoryTest.this.serverDestination);
                        for (int i = 0; i < this.numToSend; ++i) {
                            TemporaryQueue replyTo = session.createTemporaryQueue();
                            MessageConsumer consumer = session.createConsumer((Destination)replyTo);
                            Message msg = session.createMessage();
                            msg.setJMSReplyTo((Destination)replyTo);
                            producer.send(msg);
                            if (TempQueueMemoryTest.this.clientTransactional) {
                                session.commit();
                            }
                            consumer.receive();
                            if (TempQueueMemoryTest.this.clientTransactional) {
                                session.commit();
                            }
                            consumer.close();
                            if (!TempQueueMemoryTest.this.deleteTempQueue) continue;
                            replyTo.delete();
                        }
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
            threads.add(new Producer(this.messagesToSend / this.numProducers));
        }
        this.startAndJoinThreads(threads);
        this.clientSession.close();
        this.serverSession.close();
        this.clientConnection.close();
        this.serverConnection.close();
        AdvisoryBroker ab = (AdvisoryBroker)this.broker.getBroker().getAdaptor(AdvisoryBroker.class);
        TempQueueMemoryTest.assertTrue((ab.getAdvisoryDestinations().size() == 1 ? 1 : 0) != 0);
        TempQueueMemoryTest.assertTrue((String)("should be zero but is " + ab.getAdvisoryConsumers().size()), (ab.getAdvisoryConsumers().size() == 0 ? 1 : 0) != 0);
        TempQueueMemoryTest.assertTrue((String)("should be zero but is " + ab.getAdvisoryProducers().size()), (ab.getAdvisoryProducers().size() == 0 ? 1 : 0) != 0);
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        TempQueueMemoryTest.assertEquals((int)6, (int)rb.getDestinationMap().size());
    }

    private void startAndJoinThreads(Vector<Thread> threads) throws Exception {
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.serverConnection = this.createConnection();
        this.serverConnection.start();
        this.serverSession = this.serverConnection.createSession(false, 1);
        this.clientConnection = this.createConnection();
        this.clientConnection.start();
        this.clientSession = this.clientConnection.createSession(false, 1);
        this.serverDestination = this.createDestination();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.clientTransactional = false;
        this.serverTransactional = false;
        this.numProducers = 1;
        this.numConsumers = 1;
        this.messagesToSend = 2000;
    }

    @Override
    protected ActiveMQDestination createDestination() {
        return new ActiveMQQueue(((Object)((Object)this)).getClass().getName());
    }
}

