/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NioQueueSubscriptionTest
extends QueueSubscriptionTest
implements ExceptionListener {
    protected static final Log LOG = LogFactory.getLog(NioQueueSubscriptionTest.class);
    private Map<Thread, Throwable> exceptions = Collections.synchronizedMap(new HashMap());

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("tcp://localhost:62621?trace=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = BrokerFactory.createBroker((URI)new URI("broker://nio://localhost:62621?useQueueForAccept=false&persistent=false&wiewformat.maxInactivityDuration=0"));
        answer.getManagementContext().setCreateConnector(false);
        answer.setUseJmx(false);
        answer.setDeleteAllMessagesOnStartup(true);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setOptimizedDispatch(true);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        answer.setDestinationPolicy(policyMap);
        return answer;
    }

    public void testLotsOfConcurrentConnections() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        final ConnectionFactory factory = this.createConnectionFactory();
        final NioQueueSubscriptionTest listener = this;
        int connectionCount = 400;
        for (int i = 0; i < connectionCount; ++i) {
            executor.execute(new Runnable(){

                public void run() {
                    try {
                        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
                        connection.setExceptionListener(listener);
                        connection.start();
                        Assert.assertNotNull((Object)connection.getBrokerName());
                        NioQueueSubscriptionTest.this.connections.add(connection);
                    }
                    catch (Exception e) {
                        NioQueueSubscriptionTest.this.exceptions.put(Thread.currentThread(), e);
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        if (!this.exceptions.isEmpty()) {
            LOG.error((Object)("" + this.exceptions.size() + " exceptions like"), this.exceptions.values().iterator().next());
            NioQueueSubscriptionTest.fail((String)("unexpected exceptions in worker threads: " + this.exceptions.values().iterator().next()));
        }
        LOG.info((Object)("created " + connectionCount + " connecitons"));
    }

    public void onException(JMSException exception) {
        LOG.error((Object)"Exception on conneciton", (Throwable)exception);
        this.exceptions.put(Thread.currentThread(), exception);
    }
}

