/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.activemq.broker.ft.JDBCQueueMasterSlaveTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class DbRestartJDBCQueueMasterSlaveTest
extends JDBCQueueMasterSlaveTest {
    private static final transient Log LOG = LogFactory.getLog(DbRestartJDBCQueueMasterSlaveTest.class);

    protected void messageSent() throws Exception {
        if (++this.inflightMessageCount == this.failureCount) {
            LOG.info((Object)"STOPPING DB!@!!!!");
            final EmbeddedDataSource ds = this.getExistingDataSource();
            ds.setShutdownDatabase("shutdown");
            LOG.info((Object)"DB STOPPED!@!!!!");
            Thread dbRestartThread = new Thread("db-re-start-thread"){

                public void run() {
                    LOG.info((Object)"Waiting for master broker to Stop");
                    DbRestartJDBCQueueMasterSlaveTest.this.master.waitUntilStopped();
                    ds.setShutdownDatabase("false");
                    LOG.info((Object)"DB RESTARTED!@!!!!");
                }
            };
            dbRestartThread.start();
        }
    }

    protected void sendToProducer(MessageProducer producer, Destination producerDestination, Message message) throws JMSException {
        boolean sent = false;
        do {
            try {
                producer.send(producerDestination, message);
                sent = true;
            }
            catch (JMSException e) {
                LOG.info((Object)"Exception on producer send:", (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        } while (!sent);
    }
}

