/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.net.URI;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.QueueMasterSlaveTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;

public class QueueMasterSlaveSingleUrlTest
extends QueueMasterSlaveTest {
    private final String brokerUrl = "tcp://localhost:62001";
    private final String singleUriString = "failover://(tcp://localhost:62001)?randomize=false";

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("failover://(tcp://localhost:62001)?randomize=false");
    }

    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setBrokerName("shared-master");
        this.configureSharedPersistenceAdapter(this.master);
        this.master.addConnector("tcp://localhost:62001");
        this.master.start();
    }

    private void configureSharedPersistenceAdapter(BrokerService broker) throws Exception {
        AMQPersistenceAdapter adapter = new AMQPersistenceAdapter();
        adapter.setDirectory(new File("shared"));
        broker.setPersistenceAdapter((PersistenceAdapter)adapter);
    }

    protected void createSlave() throws Exception {
        new Thread(new Runnable(){

            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.setBrokerName("shared-slave");
                    QueueMasterSlaveSingleUrlTest.this.configureSharedPersistenceAdapter(broker);
                    TransportConnector tConnector = new TransportConnector();
                    tConnector.setUri(new URI("tcp://localhost:62001"));
                    broker.addConnector(tConnector);
                    broker.start();
                    QueueMasterSlaveSingleUrlTest.this.slave.set(broker);
                    QueueMasterSlaveSingleUrlTest.this.slaveStarted.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

