/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.File;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueuePurgeTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(QueuePurgeTest.class);
    private final String MESSAGE_TEXT = new String(new byte[1024]);
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    Queue queue;
    MessageConsumer consumer;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target/activemq-data");
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("target/activemq-data/kahadb/QueuePurgeTest"));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    public void testPurgeQueueWithActiveConsumer() throws Exception {
        this.createProducerAndSendMessages(10000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        this.createConsumer();
        proxy.purge();
        QueuePurgeTest.assertEquals((String)("Queue size is not zero, it's " + proxy.getQueueSize()), (long)0L, (long)proxy.getQueueSize());
    }

    public void testPurgeLargeQueue() throws Exception {
        this.applyBrokerSpoolingPolicy();
        this.createProducerAndSendMessages(90000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        LOG.info((Object)"purging..");
        proxy.purge();
        QueuePurgeTest.assertEquals((String)("Queue size is not zero, it's " + proxy.getQueueSize()), (long)0L, (long)proxy.getQueueSize());
    }

    public void testRepeatedExpiryProcessingOfLargeQueue() throws Exception {
        this.applyBrokerSpoolingPolicy();
        int exprityPeriod = 1000;
        this.applyExpiryDuration(1000);
        this.createProducerAndSendMessages(90000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        LOG.info((Object)"waiting for expiry to kick in a bunch of times to verify it does not blow mem");
        Thread.sleep(10000L);
        QueuePurgeTest.assertEquals((String)("Queue size is has not changed " + proxy.getQueueSize()), (long)90000L, (long)proxy.getQueueSize());
    }

    private void applyExpiryDuration(int i) {
        this.broker.getDestinationPolicy().getDefaultEntry().setExpireMessagesPeriod((long)i);
    }

    private void applyBrokerSpoolingPolicy() {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setProducerFlowControl(false);
        FilePendingQueueMessageStoragePolicy pendingQueuePolicy = new FilePendingQueueMessageStoragePolicy();
        defaultEntry.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)pendingQueuePolicy);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
    }

    public void testPurgeLargeQueueWithConsumer() throws Exception {
        this.applyBrokerSpoolingPolicy();
        this.createProducerAndSendMessages(90000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        this.createConsumer();
        long start = System.currentTimeMillis();
        LOG.info((Object)"purging..");
        proxy.purge();
        LOG.info((Object)("purge done: " + (System.currentTimeMillis() - start) + "ms"));
        QueuePurgeTest.assertEquals((String)("Queue size is not zero, it's " + proxy.getQueueSize()), (long)0L, (long)proxy.getQueueSize());
        QueuePurgeTest.assertEquals((String)"usage goes to duck", (int)0, (int)proxy.getMemoryPercentUsage());
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:Type=Queue,Destination=" + this.queue.getQueueName() + ",BrokerName=localhost");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    private void createProducerAndSendMessages(int numToSend) throws Exception {
        this.session = this.connection.createSession(false, 2);
        this.queue = this.session.createQueue("test1");
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        for (int i = 0; i < numToSend; ++i) {
            TextMessage message = this.session.createTextMessage(this.MESSAGE_TEXT + i);
            if (i != 0 && i % 50000 == 0) {
                LOG.info((Object)("sent: " + i));
            }
            producer.send((Message)message);
        }
        producer.close();
    }

    private void createConsumer() throws Exception {
        this.consumer = this.session.createConsumer((Destination)this.queue);
        Thread.sleep(5000L);
        for (int i = 0; i < 500; ++i) {
            Message message = this.consumer.receive();
            message.acknowledge();
        }
    }
}

