/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CursorSupport
extends CombinationTestSupport {
    public int MESSAGE_COUNT = 500;
    public int PREFETCH_SIZE = 50;
    private static final Log LOG = LogFactory.getLog(CursorSupport.class);
    protected BrokerService broker;
    protected String bindAddress = "tcp://localhost:60706";

    protected abstract Destination getDestination(Session var1) throws JMSException;

    protected abstract MessageConsumer getConsumer(Connection var1) throws Exception;

    protected abstract void configureBroker(BrokerService var1) throws Exception;

    public void testSendFirstThenConsume() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        Connection consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        MessageConsumer consumer = this.getConsumer(consumerConnection);
        consumerConnection.close();
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.getDestination(session));
        ArrayList<TextMessage> senderList = new ArrayList<TextMessage>();
        for (int i = 0; i < this.MESSAGE_COUNT; ++i) {
            TextMessage msg = session.createTextMessage("test" + i);
            senderList.add(msg);
            producer.send((Message)msg);
        }
        producerConnection.close();
        consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        consumer = this.getConsumer(consumerConnection);
        ArrayList<Message> consumerList = new ArrayList<Message>();
        for (int i = 0; i < this.MESSAGE_COUNT; ++i) {
            Message msg = consumer.receive(5000L);
            CursorSupport.assertNotNull((String)("Message " + i + " was missing."), (Object)msg);
            consumerList.add(msg);
        }
        CursorSupport.assertEquals(senderList, consumerList);
        consumerConnection.close();
    }

    public void initCombosForTestSendWhilstConsume() {
        this.addCombinationValues("MESSAGE_COUNT", new Object[]{400, 500});
        this.addCombinationValues("PREFETCH_SIZE", new Object[]{100, 50});
    }

    public void testSendWhilstConsume() throws Exception {
        int i;
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        Connection consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        MessageConsumer consumer = this.getConsumer(consumerConnection);
        consumerConnection.close();
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.getDestination(session));
        ArrayList<TextMessage> senderList = new ArrayList<TextMessage>();
        for (int i2 = 0; i2 < this.MESSAGE_COUNT / 10; ++i2) {
            TextMessage msg = session.createTextMessage("test" + i2);
            senderList.add(msg);
            producer.send((Message)msg);
        }
        consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        consumer = this.getConsumer(consumerConnection);
        final ArrayList consumerList = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(1);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                consumerList.add(msg);
                if (consumerList.size() == CursorSupport.this.MESSAGE_COUNT) {
                    latch.countDown();
                }
            }
        });
        for (i = this.MESSAGE_COUNT / 10; i < this.MESSAGE_COUNT; ++i) {
            TextMessage msg = session.createTextMessage("test" + i);
            senderList.add(msg);
            producer.send((Message)msg);
        }
        latch.await(300000L, TimeUnit.MILLISECONDS);
        producerConnection.close();
        consumerConnection.close();
        CursorSupport.assertEquals((String)"Still dipatching - count down latch not sprung", (long)latch.getCount(), (long)0L);
        for (i = 0; i < senderList.size(); ++i) {
            Message consumed;
            Message sent = (Message)senderList.get(i);
            if (!sent.equals(consumed = (Message)consumerList.get(i))) {
                LOG.error((Object)("BAD MATCH AT POS " + i));
                LOG.error((Object)sent);
                LOG.error((Object)consumed);
            }
            CursorSupport.assertEquals((String)("This should be the same at pos " + i + " in the list"), (String)sent.getJMSMessageID(), (String)consumed.getJMSMessageID());
        }
    }

    protected Connection getConsumerConnection(ConnectionFactory fac) throws JMSException {
        Connection connection = fac.createConnection();
        connection.setClientID("testConsumer");
        connection.start();
        return connection;
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.bindAddress);
        Properties props = new Properties();
        props.setProperty("prefetchPolicy.durableTopicPrefetch", "" + this.PREFETCH_SIZE);
        props.setProperty("prefetchPolicy.optimizeDurableTopicPrefetch", "" + this.PREFETCH_SIZE);
        props.setProperty("prefetchPolicy.queuePrefetch", "" + this.PREFETCH_SIZE);
        cf.setProperties(props);
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }
}

