/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.QueueStorePrefetch;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.usage.SystemUsage;

public class StoreQueueCursorNoDuplicateTest
extends TestCase {
    ActiveMQQueue destination = new ActiveMQQueue("queue-" + StoreQueueCursorNoDuplicateTest.class.getSimpleName());
    BrokerService brokerService;
    static final String mesageIdRoot = "11111:22222:";
    final int messageBytesSize = 1024;
    final String text = new String(new byte[1024]);
    protected int count = 6;

    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.setUseJmx(false);
        this.brokerService.deleteAllMessages();
        this.brokerService.start();
    }

    protected BrokerService createBroker() throws Exception {
        return new BrokerService();
    }

    public void tearDown() throws Exception {
        this.brokerService.stop();
    }

    public void testNoDuplicateAfterCacheFullAndReadPast() throws Exception {
        PersistenceAdapter persistenceAdapter = this.brokerService.getPersistenceAdapter();
        MessageStore queueMessageStore = persistenceAdapter.createQueueMessageStore(this.destination);
        ConsumerInfo consumerInfo = new ConsumerInfo();
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        consumerInfo.setExclusive(true);
        Queue queue = new Queue(this.brokerService, (ActiveMQDestination)this.destination, queueMessageStore, destinationStatistics, null);
        queueMessageStore.start();
        QueueStorePrefetch underTest = new QueueStorePrefetch(queue);
        SystemUsage systemUsage = new SystemUsage();
        systemUsage.getMemoryUsage().setLimit((long)(1024 * (this.count + 2)));
        underTest.setSystemUsage(systemUsage);
        underTest.setEnableAudit(false);
        underTest.start();
        ConnectionContext contextNotInTx = new ConnectionContext();
        for (int i = 0; i < this.count; ++i) {
            ActiveMQTextMessage msg = this.getMessage(i);
            msg.setMemoryUsage(systemUsage.getMemoryUsage());
            queueMessageStore.addMessage(contextNotInTx, (Message)msg);
            underTest.addMessageLast((MessageReference)msg);
        }
        int dequeueCount = 0;
        underTest.setMaxBatchSize(2);
        underTest.reset();
        while (underTest.hasNext() && dequeueCount < this.count) {
            MessageReference ref = underTest.next();
            ref.decrementReferenceCount();
            underTest.remove();
            StoreQueueCursorNoDuplicateTest.assertEquals((long)dequeueCount++, (long)ref.getMessageId().getProducerSequenceId());
        }
        underTest.release();
        StoreQueueCursorNoDuplicateTest.assertEquals((int)this.count, (int)dequeueCount);
    }

    private ActiveMQTextMessage getMessage(int i) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        MessageId id = new MessageId(mesageIdRoot + i);
        id.setBrokerSequenceId((long)i);
        id.setProducerSequenceId((long)i);
        message.setMessageId(id);
        message.setDestination((ActiveMQDestination)this.destination);
        message.setPersistent(true);
        message.setResponseRequired(true);
        message.setText("Msg:" + i + " " + this.text);
        StoreQueueCursorNoDuplicateTest.assertEquals((long)message.getMessageId().getProducerSequenceId(), (long)i);
        return message;
    }
}

