/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.util.Calendar;
import java.util.List;
import javax.jms.MessageFormatException;
import org.apache.activemq.broker.scheduler.CronParser;
import org.junit.Assert;
import org.junit.Test;

public class CronParserTest {
    @Test
    public void testgetNextTimeMinutes() throws MessageFormatException {
        String test = "30 * * * *";
        long current = 1200000L;
        Calendar calender = Calendar.getInstance();
        calender.setTimeInMillis(current);
        System.out.println("start:" + calender.getTime());
        long next = CronParser.getNextScheduledTime((String)test, (long)current);
        calender.setTimeInMillis(next);
        System.out.println("next:" + calender.getTime());
        long result = next - current;
        Assert.assertEquals((long)600000L, (long)result);
    }

    @Test
    public void testgetNextTimeHours() throws MessageFormatException {
        String test = "* 1 * * *";
        Calendar calender = Calendar.getInstance();
        calender.set(1972, 2, 2, 17, 10, 0);
        long current = calender.getTimeInMillis();
        long next = CronParser.getNextScheduledTime((String)test, (long)current);
        calender.setTimeInMillis(next);
        long result = next - current;
        long expected = 28800000L;
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void testgetNextTimeHoursZeroMin() throws MessageFormatException {
        String test = "0 1 * * *";
        Calendar calender = Calendar.getInstance();
        calender.set(1972, 2, 2, 17, 10, 0);
        long current = calender.getTimeInMillis();
        long next = CronParser.getNextScheduledTime((String)test, (long)current);
        calender.setTimeInMillis(next);
        long result = next - current;
        long expected = 28200000L;
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void testValidate() {
        try {
            CronParser.validate((String)"30 08 10 06 * ");
            CronParser.validate((String)"* * * * * ");
            CronParser.validate((String)"* * * * 1-6 ");
            CronParser.validate((String)"* * * * 1,2,5 ");
            CronParser.validate((String)"*/10 0-4,8-12 * * 1-2,3-6/2 ");
        }
        catch (Exception e) {
            Assert.fail((String)"Should be valid ");
        }
        try {
            CronParser.validate((String)"61 08 10 06 * ");
            Assert.fail((String)"Should not be valid ");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CronParser.validate((String)"61 08 06 * ");
            Assert.fail((String)"Should not be valid ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetNextCommaSeparated() throws MessageFormatException {
        String token = "3,5,7";
        int next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)3);
        Assert.assertEquals((long)2L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)8);
        Assert.assertEquals((long)4L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)1);
        Assert.assertEquals((long)2L, (long)next);
    }

    @Test
    public void testGetNextRange() throws MessageFormatException {
        String token = "3-5";
        int next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)3);
        Assert.assertEquals((long)1L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)5);
        Assert.assertEquals((long)7L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)6);
        Assert.assertEquals((long)6L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)1);
        Assert.assertEquals((long)2L, (long)next);
    }

    @Test
    public void testGetNextExact() throws MessageFormatException {
        String token = "3";
        int next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 0, 10), (int)2);
        Assert.assertEquals((long)1L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 0, 10), (int)3);
        Assert.assertEquals((long)10L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 0, 10), (int)1);
        Assert.assertEquals((long)2L, (long)next);
    }

    @Test
    public void testTokenize() {
        String test = "*/5 * * * *";
        List list = CronParser.tokenize((String)test);
        Assert.assertEquals((long)list.size(), (long)5L);
        test = "*/5 * * * * *";
        try {
            list = CronParser.tokenize((String)test);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Throwable e) {
            // empty catch block
        }
        test = "*/5 * * * *";
        try {
            list = CronParser.tokenize((String)test);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testGetNextScheduledTime() {
        Assert.fail((String)"Not yet implemented");
    }

    CronParser.CronEntry createEntry(String str, int start, int end) {
        return new CronParser.CronEntry("test", str, start, end);
    }
}

