/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ2084Test {
    private static final Log LOG = LogFactory.getLog(AMQ2084Test.class);
    BrokerService broker;
    CountDownLatch qreceived;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:61616");
        this.broker.start();
        this.qreceived = new CountDownLatch(1);
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void listenQueue(final String queueName, String selectors) {
        try {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            props.put("java.naming.provider.url", "tcp://localhost:61616");
            props.put("queue.queueName", queueName);
            InitialContext ctx = new InitialContext(props);
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("ConnectionFactory");
            QueueConnection conn = factory.createQueueConnection();
            Queue queue = (Queue)ctx.lookup("queueName");
            QueueSession session = conn.createQueueSession(false, 1);
            QueueReceiver receiver = session.createReceiver(queue, selectors);
            System.out.println("Message Selector: " + receiver.getMessageSelector());
            receiver.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        if (message instanceof TextMessage) {
                            TextMessage txtMsg = (TextMessage)message;
                            String msg = txtMsg.getText();
                            LOG.info((Object)("Queue Message Received: " + queueName + " - " + msg));
                            AMQ2084Test.this.qreceived.countDown();
                        }
                        message.acknowledge();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            conn.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void listenTopic(final String topicName, String selectors) {
        try {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            props.put("java.naming.provider.url", "tcp://localhost:61616");
            props.put("topic.topicName", topicName);
            InitialContext ctx = new InitialContext(props);
            TopicConnectionFactory factory = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            TopicConnection conn = factory.createTopicConnection();
            Topic topic = (Topic)ctx.lookup("topicName");
            TopicSession session = conn.createTopicSession(false, 1);
            TopicSubscriber receiver = session.createSubscriber(topic, selectors, false);
            receiver.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        if (message instanceof TextMessage) {
                            TextMessage txtMsg = (TextMessage)message;
                            String msg = txtMsg.getText();
                            LOG.info((Object)("Topic Message Received: " + topicName + " - " + msg));
                        }
                        message.acknowledge();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            conn.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void publish(String topicName, String message) {
        try {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            props.put("java.naming.provider.url", "tcp://localhost:61616");
            props.put("topic.topicName", topicName);
            InitialContext ctx = new InitialContext(props);
            TopicConnectionFactory factory = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            TopicConnection conn = factory.createTopicConnection();
            Topic topic = (Topic)ctx.lookup("topicName");
            TopicSession session = conn.createTopicSession(false, 1);
            TopicPublisher publisher = session.createPublisher(topic);
            if (message != null) {
                TextMessage msg = session.createTextMessage(message);
                publisher.send((Message)msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void tryXpathSelectorMatch() throws Exception {
        String xPath = "XPATH '//books//book[@lang=''en'']'";
        this.listenQueue("Consumer.Sample.VirtualTopic.TestXpath", xPath);
        this.publish("VirtualTopic.TestXpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><books><book lang=\"en\">ABC</book></books>");
        Assert.assertTrue((String)"topic received: ", (boolean)this.qreceived.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void tryXpathSelectorNoMatch() throws Exception {
        String xPath = "XPATH '//books//book[@lang=''es'']'";
        this.listenQueue("Consumer.Sample.VirtualTopic.TestXpath", xPath);
        this.publish("VirtualTopic.TestXpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><books><book lang=\"en\">ABC</book></books>");
        Assert.assertFalse((String)"topic did not receive unmatched", (boolean)this.qreceived.await(5L, TimeUnit.SECONDS));
    }
}

