/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.AutoFailTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQ2183Test
extends AutoFailTestSupport
implements Thread.UncaughtExceptionHandler,
MessageListener {
    private static final Log LOG = LogFactory.getLog(AMQ2183Test.class);
    private static final int maxSent = 2000;
    private final Map<Thread, Throwable> exceptions = new ConcurrentHashMap<Thread, Throwable>();
    BrokerService master = new BrokerService();
    BrokerService slave = new BrokerService();
    URI masterUrl;
    URI slaveUrl;

    public void onException(JMSException e) {
        this.exceptions.put(Thread.currentThread(), e);
    }

    public void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
        this.master = new BrokerService();
        this.slave = new BrokerService();
        this.master.setBrokerName("Master");
        this.master.addConnector("tcp://localhost:0");
        this.master.deleteAllMessages();
        this.master.setWaitForSlave(true);
        Thread t = new Thread(){

            public void run() {
                try {
                    AMQ2183Test.this.master.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AMQ2183Test.this.exceptions.put(Thread.currentThread(), e);
                }
            }
        };
        t.start();
        Thread.sleep(2000L);
        this.masterUrl = ((TransportConnector)this.master.getTransportConnectors().get(0)).getConnectUri();
    }

    private void startSlave() throws IOException, Exception, URISyntaxException {
        this.slave.setBrokerName("Slave");
        this.slave.deleteAllMessages();
        this.slave.addConnector("tcp://localhost:0");
        this.slave.setMasterConnectorURI(this.masterUrl.toString());
        this.slave.start();
        this.slaveUrl = ((TransportConnector)this.slave.getTransportConnectors().get(0)).getConnectUri();
    }

    public void tearDown() throws Exception {
        this.master.stop();
        this.slave.stop();
        this.exceptions.clear();
    }

    public void testMasterSlaveBugWithStopStartConsumers() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + this.masterUrl + ")?randomize=false");
        final Connection connection = connectionFactory.createConnection();
        final CountDownLatch startCommenced = new CountDownLatch(1);
        final CountDownLatch startDone = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                startCommenced.countDown();
                try {
                    connection.start();
                    startDone.countDown();
                }
                catch (Exception e) {
                    AMQ2183Test.this.exceptions.put(Thread.currentThread(), e);
                }
            }
        });
        AMQ2183Test.assertTrue((String)"connection.start has commenced", (boolean)startCommenced.await(10L, TimeUnit.SECONDS));
        this.startSlave();
        AMQ2183Test.assertTrue((String)"connection.start done", (boolean)startDone.await(70L, TimeUnit.SECONDS));
        final MessageCounter counterA = new MessageCounter();
        connection.createSession(false, 1).createConsumer((Destination)new ActiveMQQueue("Consumer.A.VirtualTopic.T")).setMessageListener((MessageListener)counterA);
        final MessageCounter counterB = new MessageCounter();
        connection.createSession(false, 1).createConsumer((Destination)new ActiveMQQueue("Consumer.B.VirtualTopic.T")).setMessageListener((MessageListener)counterB);
        Thread.sleep(2000L);
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQTopic("VirtualTopic.T"));
        for (int i = 0; i < 2000; ++i) {
            producer.send((Message)session.createTextMessage("Hi" + i));
        }
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 2000 == counterA.getCount() && 2000 == counterB.getCount();
            }
        });
        AMQ2183Test.assertEquals((int)2000, (int)counterA.getCount());
        AMQ2183Test.assertEquals((int)2000, (int)counterB.getCount());
        AMQ2183Test.assertTrue((boolean)this.exceptions.isEmpty());
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.exceptions.put(t, e);
    }

    public void onMessage(Message message) {
        LOG.info((Object)("message received: " + message));
    }

    class MessageCounter
    implements MessageListener {
        int count = 0;

        MessageCounter() {
        }

        public void onMessage(Message message) {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }
    }
}

