/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;

public class AMQ2513Test
extends TestCase {
    BrokerService broker;

    void createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("localhost");
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        this.broker.addConnector("tcp://localhost:61616");
        ManagementContext ctx = new ManagementContext();
        ctx.setCreateConnector(false);
        this.broker.setManagementContext(ctx);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    public void testJmx() throws Exception {
        this.createBroker(true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("test"));
        producer.setDeliveryMode(2);
        connection.start();
        producer.send((Message)session.createTextMessage("test123"));
        DestinationViewMBean dv = this.createView();
        AMQ2513Test.assertTrue((dv.getQueueSize() > 0L ? 1 : 0) != 0);
        connection.close();
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.createBroker(false);
        factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        connection = factory.createConnection();
        session = connection.createSession(false, 1);
        producer = session.createProducer((Destination)session.createQueue("test"));
        producer.setDeliveryMode(2);
        connection.start();
        producer.send((Message)session.createTextMessage("test123"));
        connection.close();
        dv = this.createView();
        AMQ2513Test.assertTrue((dv.getQueueSize() > 0L ? 1 : 0) != 0);
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    DestinationViewMBean createView() throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = new ObjectName(domain + ":BrokerName=localhost,Type=Queue,Destination=test");
        return (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }
}

