/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Map;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQ2870Test
extends TestSupport {
    static final Log LOG = LogFactory.getLog(AMQ2870Test.class);
    BrokerService broker = null;
    ActiveMQTopic topic;
    ActiveMQConnection consumerConnection = null;
    ActiveMQConnection producerConnection = null;
    Session producerSession;
    MessageProducer producer;
    final int minPercentUsageForStore = 10;
    String data;

    public static Test suite() {
        return AMQ2870Test.suite(AMQ2870Test.class);
    }

    public void initCombosForTestSize() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.AMQ});
    }

    public void testSize() throws Exception {
        this.openConsumer();
        AMQ2870Test.assertEquals((int)0, (int)this.broker.getAdminView().getStorePercentUsage());
        for (int i = 0; i < 5000; ++i) {
            this.sendMessage(false);
        }
        final BrokerView brokerView = this.broker.getAdminView();
        AMQ2870Test.assertTrue((String)"in range with consumer", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                AMQ2870Test.this.broker.getSystemUsage().getStoreUsage().isFull();
                LOG.info((Object)("store precent usage: " + brokerView.getStorePercentUsage()));
                return AMQ2870Test.this.broker.getAdminView().getStorePercentUsage() < 10;
            }
        }));
        this.closeConsumer();
        AMQ2870Test.assertTrue((String)"in range with closed consumer", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                AMQ2870Test.this.broker.getSystemUsage().getStoreUsage().isFull();
                LOG.info((Object)("store precent usage: " + brokerView.getStorePercentUsage()));
                return AMQ2870Test.this.broker.getAdminView().getStorePercentUsage() < 10;
            }
        }));
        for (int i = 0; i < 5000; ++i) {
            this.sendMessage(false);
        }
        this.broker.getAdminView().destroyDurableSubscriber("cliID", "subName");
        AMQ2870Test.assertTrue((String)"in range after send with consumer", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                AMQ2870Test.this.broker.getSystemUsage().getStoreUsage().isFull();
                LOG.info((Object)("store precent usage: " + brokerView.getStorePercentUsage()));
                return AMQ2870Test.this.broker.getAdminView().getStorePercentUsage() < 10;
            }
        }));
    }

    private void openConsumer() throws Exception {
        this.consumerConnection = (ActiveMQConnection)this.createConnection();
        this.consumerConnection.setClientID("cliID");
        this.consumerConnection.start();
        Session session = this.consumerConnection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)this.topic, "subName", "filter=true", false);
        subscriber.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
    }

    private void closeConsumer() throws JMSException {
        if (this.consumerConnection != null) {
            this.consumerConnection.close();
        }
        this.consumerConnection = null;
    }

    private void sendMessage(boolean filter) throws Exception {
        if (this.producerConnection == null) {
            this.producerConnection = (ActiveMQConnection)this.createConnection();
            this.producerConnection.start();
            this.producerSession = this.producerConnection.createSession(false, 1);
            this.producer = this.producerSession.createProducer((Destination)this.topic);
        }
        Message message = this.producerSession.createMessage();
        message.setBooleanProperty("filter", filter);
        message.setStringProperty("data", this.data);
        this.producer.send(message);
    }

    private void startBroker(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        this.broker.setAdvisorySupport(false);
        this.broker.setBrokerName("testStoreSize");
        if (deleteMessages) {
            this.broker.setDeleteAllMessagesOnStartup(true);
        }
        this.setDefaultPersistenceAdapter(this.broker);
        this.configurePersistenceAdapter(this.broker.getPersistenceAdapter());
        this.broker.getSystemUsage().getStoreUsage().setLimit(100000000L);
        this.broker.start();
    }

    private void configurePersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        Properties properties = new Properties();
        String maxFileLengthVal = String.valueOf(0x200000);
        properties.put("journalMaxFileLength", maxFileLengthVal);
        properties.put("maxFileLength", maxFileLengthVal);
        properties.put("cleanupInterval", "2000");
        properties.put("checkpointInterval", "2000");
        IntrospectionSupport.setProperties((Object)persistenceAdapter, (Map)properties);
    }

    private void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
        this.broker = null;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://testStoreSize?jms.watchTopicAdvisories=false&waitForStart=5000&create=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
        StringBuilder sb = new StringBuilder(5000);
        for (int i = 0; i < 5000; ++i) {
            sb.append('a');
        }
        this.data = sb.toString();
        this.startBroker(true);
        this.topic = (ActiveMQTopic)this.createDestination();
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }
}

