/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.transport.tcp.SslBrokerServiceTest;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FailoverStaticNetworkTest {
    protected static final Log LOG = LogFactory.getLog(FailoverStaticNetworkTest.class);
    private static final String DESTINATION_NAME = "testQ";
    protected BrokerService brokerA;
    protected BrokerService brokerB;
    private SslContext sslContext;

    protected BrokerService createBroker(String scheme, String listenPort, String[] networkToPorts) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        broker.getManagementContext().setCreateConnector(false);
        broker.setSslContext(this.sslContext);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setBrokerName("Broker_" + listenPort);
        broker.addConnector(scheme + "://localhost:" + listenPort);
        if (networkToPorts != null && networkToPorts.length > 0) {
            StringBuilder builder = new StringBuilder("static:(failover:(" + scheme + "://localhost:");
            builder.append(networkToPorts[0]);
            for (int i = 1; i < networkToPorts.length; ++i) {
                builder.append("," + scheme + "://localhost:" + networkToPorts[i]);
            }
            builder.append(")?randomize=false)");
            broker.addNetworkConnector(builder.toString());
        }
        return broker;
    }

    @Before
    public void setUp() throws Exception {
        KeyManager[] km = SslBrokerServiceTest.getKeyManager();
        TrustManager[] tm = SslBrokerServiceTest.getTrustManager();
        this.sslContext = new SslContext(km, tm, null);
    }

    @After
    public void tearDown() throws Exception {
        this.brokerB.stop();
        this.brokerB.waitUntilStopped();
        this.brokerA.stop();
        this.brokerA.waitUntilStopped();
    }

    @Test
    public void testSendReceiveAfterReconnect() throws Exception {
        this.brokerA = this.createBroker("tcp", "61617", null);
        this.brokerA.start();
        this.brokerB = this.createBroker("tcp", "62617", new String[]{"61617"});
        this.brokerB.start();
        this.doTestNetworkSendReceive();
        LOG.info((Object)"stopping brokerA");
        this.brokerA.stop();
        this.brokerA.waitUntilStopped();
        LOG.info((Object)"restarting brokerA");
        this.brokerA = this.createBroker("tcp", "61617", null);
        this.brokerA.start();
        this.doTestNetworkSendReceive();
    }

    @Test
    public void testSendReceiveFailover() throws Exception {
        this.brokerA = this.createBroker("tcp", "61617", null);
        this.brokerA.start();
        this.brokerB = this.createBroker("tcp", "62617", new String[]{"61617", "63617"});
        this.brokerB.start();
        this.doTestNetworkSendReceive();
        LOG.info((Object)"stopping brokerA");
        this.brokerA.stop();
        this.brokerA.waitUntilStopped();
        LOG.info((Object)"restarting brokerA");
        this.brokerA = this.createBroker("tcp", "63617", null);
        this.brokerA.start();
        this.doTestNetworkSendReceive();
    }

    @Test
    public void testSendReceive() throws Exception {
        this.brokerA = this.createBroker("tcp", "61617", null);
        this.brokerA.start();
        this.brokerB = this.createBroker("tcp", "62617", new String[]{"61617", "1111"});
        this.brokerB.start();
        this.doTestNetworkSendReceive();
    }

    @Test
    public void testSendReceiveSsl() throws Exception {
        this.brokerA = this.createBroker("ssl", "61617", null);
        this.brokerA.start();
        this.brokerB = this.createBroker("ssl", "62617", new String[]{"61617", "1111"});
        this.brokerB.start();
        this.doTestNetworkSendReceive();
    }

    private void doTestNetworkSendReceive() throws Exception, JMSException {
        LOG.info((Object)"Creating Consumer on the networked brokerA ...");
        SslContext.setCurrentSslContext((SslContext)this.sslContext);
        ConnectionFactory consFactory = this.createConnectionFactory(this.brokerA);
        Connection consConn = consFactory.createConnection();
        consConn.start();
        Session consSession = consConn.createSession(false, 1);
        ActiveMQDestination destination = (ActiveMQDestination)consSession.createQueue(DESTINATION_NAME);
        final MessageConsumer consumer = consSession.createConsumer((Destination)destination);
        LOG.info((Object)"publishing to brokerB");
        this.sendMessageTo(destination, this.brokerB);
        boolean gotMessage = Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return consumer.receive(1000L) != null;
            }
        });
        try {
            consConn.close();
        }
        catch (JMSException ignored) {
            // empty catch block
        }
        Assert.assertTrue((String)"consumer on A got message", (boolean)gotMessage);
    }

    private void sendMessageTo(ActiveMQDestination destination, BrokerService brokerService) throws Exception {
        ConnectionFactory factory = this.createConnectionFactory(brokerService);
        Connection conn = factory.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        session.createProducer((Destination)destination).send((Message)session.createTextMessage("Hi"));
        conn.close();
    }

    protected ConnectionFactory createConnectionFactory(BrokerService broker) throws Exception {
        String url = ((TransportConnector)broker.getTransportConnectors().get(0)).getServer().getConnectURI().toString();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(url);
        connectionFactory.setOptimizedMessageDispatch(true);
        connectionFactory.setDispatchAsync(false);
        connectionFactory.setUseAsyncSend(false);
        connectionFactory.setOptimizeAcknowledge(false);
        connectionFactory.setAlwaysSyncSend(true);
        return connectionFactory;
    }
}

