/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessagePriorityTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(MessagePriorityTest.class);
    BrokerService broker;
    PersistenceAdapter adapter;
    protected ActiveMQConnectionFactory factory;
    protected Connection conn;
    protected Session sess;
    public boolean useCache = true;
    public boolean dispatchAsync = true;
    public boolean prioritizeMessages = true;
    public int prefetchVal = 500;
    public int MSG_NUM = 600;
    public int HIGH_PRI = 7;
    public int LOW_PRI = 3;

    protected abstract PersistenceAdapter createPersistenceAdapter(boolean var1) throws Exception;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("priorityTest");
        this.broker.setAdvisorySupport(false);
        this.adapter = this.createPersistenceAdapter(true);
        this.broker.setPersistenceAdapter(this.adapter);
        PolicyEntry policy = new PolicyEntry();
        policy.setPrioritizedMessages(this.prioritizeMessages);
        policy.setUseCache(this.useCache);
        PolicyMap policyMap = new PolicyMap();
        policyMap.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)policy);
        policyMap.put((ActiveMQDestination)new ActiveMQTopic("TEST"), (Object)policy);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory("vm://priorityTest");
        ActiveMQPrefetchPolicy prefetch = new ActiveMQPrefetchPolicy();
        prefetch.setAll(this.prefetchVal);
        this.factory.setPrefetchPolicy(prefetch);
        this.factory.setWatchTopicAdvisories(false);
        this.factory.setDispatchAsync(this.dispatchAsync);
        this.conn = this.factory.createConnection();
        this.conn.setClientID("priority");
        this.conn.start();
        this.sess = this.conn.createSession(false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.sess.close();
            this.conn.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    public void testStoreConfigured() throws Exception {
        Queue queue = this.sess.createQueue("TEST");
        Topic topic = this.sess.createTopic("TEST");
        MessageProducer queueProducer = this.sess.createProducer((Destination)queue);
        MessageProducer topicProducer = this.sess.createProducer((Destination)topic);
        Thread.sleep(500L);
        MessagePriorityTest.assertTrue((boolean)((org.apache.activemq.broker.region.Destination)this.broker.getRegionBroker().getDestinationMap().get(queue)).getMessageStore().isPrioritizedMessages());
        MessagePriorityTest.assertTrue((boolean)((org.apache.activemq.broker.region.Destination)this.broker.getRegionBroker().getDestinationMap().get(topic)).getMessageStore().isPrioritizedMessages());
        queueProducer.close();
        topicProducer.close();
    }

    public void initCombosForTestQueues() {
        this.addCombinationValues("useCache", new Object[]{new Boolean(true), new Boolean(false)});
    }

    public void testQueues() throws Exception {
        ActiveMQQueue queue = (ActiveMQQueue)this.sess.createQueue("TEST");
        ProducerThread lowPri = new ProducerThread((ActiveMQDestination)queue, this.MSG_NUM, this.LOW_PRI);
        ProducerThread highPri = new ProducerThread((ActiveMQDestination)queue, this.MSG_NUM, this.HIGH_PRI);
        lowPri.start();
        highPri.start();
        lowPri.join();
        highPri.join();
        MessageConsumer queueConsumer = this.sess.createConsumer((Destination)queue);
        for (int i = 0; i < this.MSG_NUM * 2; ++i) {
            Message msg = queueConsumer.receive(5000L);
            LOG.debug((Object)("received i=" + i + ", " + (msg != null ? msg.getJMSMessageID() : null)));
            MessagePriorityTest.assertNotNull((String)("Message " + i + " was null"), (Object)msg);
            MessagePriorityTest.assertEquals((String)("Message " + i + " has wrong priority"), (int)(i < this.MSG_NUM ? this.HIGH_PRI : this.LOW_PRI), (int)msg.getJMSPriority());
        }
    }

    protected Message createMessage(int priority) throws Exception {
        String text = "priority " + priority;
        TextMessage msg = this.sess.createTextMessage(text);
        LOG.info((Object)("Sending  " + text));
        return msg;
    }

    public void initCombosForTestDurableSubs() {
        this.addCombinationValues("prefetchVal", new Object[]{new Integer(1000), new Integer(this.MSG_NUM / 4)});
    }

    public void testDurableSubs() throws Exception {
        Message msg;
        int i;
        ActiveMQTopic topic = (ActiveMQTopic)this.sess.createTopic("TEST");
        TopicSubscriber sub = this.sess.createDurableSubscriber((Topic)topic, "priority");
        sub.close();
        ProducerThread lowPri = new ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.LOW_PRI);
        ProducerThread highPri = new ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.HIGH_PRI);
        lowPri.start();
        highPri.start();
        lowPri.join();
        highPri.join();
        sub = this.sess.createDurableSubscriber((Topic)topic, "priority");
        for (i = 0; i < this.MSG_NUM * 2; ++i) {
            msg = sub.receive(5000L);
            MessagePriorityTest.assertNotNull((String)("Message " + i + " was null"), (Object)msg);
            MessagePriorityTest.assertEquals((String)("Message " + i + " has wrong priority"), (int)(i < this.MSG_NUM ? this.HIGH_PRI : this.LOW_PRI), (int)msg.getJMSPriority());
        }
        topic = (ActiveMQTopic)this.sess.createTopic("HAS_NO_PRIORITY");
        sub = this.sess.createDurableSubscriber((Topic)topic, "no_priority");
        sub.close();
        lowPri = new ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.LOW_PRI);
        highPri = new ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.HIGH_PRI);
        lowPri.start();
        highPri.start();
        lowPri.join();
        highPri.join();
        sub = this.sess.createDurableSubscriber((Topic)topic, "no_priority");
        for (i = 0; i < this.MSG_NUM * 2; ++i) {
            msg = sub.receive(5000L);
            MessagePriorityTest.assertNotNull((String)("Message " + i + " was null"), (Object)msg);
        }
    }

    public void initCombosForTestDurableSubsReconnect() {
        this.addCombinationValues("prefetchVal", new Object[]{new Integer(1000), new Integer(this.MSG_NUM / 2)});
        this.addCombinationValues("dispatchAsync", new Object[]{Boolean.FALSE});
        this.addCombinationValues("useCache", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testDurableSubsReconnect() throws Exception {
        ActiveMQTopic topic = (ActiveMQTopic)this.sess.createTopic("TEST");
        String subName = "priorityDisconnect";
        TopicSubscriber sub = this.sess.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        sub.close();
        ProducerThread lowPri = new ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.LOW_PRI);
        ProducerThread highPri = new ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.HIGH_PRI);
        lowPri.start();
        highPri.start();
        lowPri.join();
        highPri.join();
        int closeFrequency = this.MSG_NUM / 4;
        sub = this.sess.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        for (int i = 0; i < this.MSG_NUM * 2; ++i) {
            Message msg = sub.receive(15000L);
            LOG.debug((Object)("received i=" + i + ", " + (msg != null ? msg.getJMSMessageID() : null)));
            MessagePriorityTest.assertNotNull((String)("Message " + i + " was null"), (Object)msg);
            MessagePriorityTest.assertEquals((String)("Message " + i + " has wrong priority"), (int)(i < this.MSG_NUM ? this.HIGH_PRI : this.LOW_PRI), (int)msg.getJMSPriority());
            if (i <= 0 || i % closeFrequency != 0) continue;
            LOG.info((Object)("Closing durable sub.. on: " + i));
            sub.close();
            sub = this.sess.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        }
    }

    protected class ProducerThread
    extends Thread {
        int priority;
        int messageCount;
        ActiveMQDestination dest;

        public ProducerThread(ActiveMQDestination dest, int messageCount, int priority) {
            this.messageCount = messageCount;
            this.priority = priority;
            this.dest = dest;
        }

        public void run() {
            try {
                MessageProducer producer = MessagePriorityTest.this.sess.createProducer((Destination)this.dest);
                producer.setPriority(this.priority);
                for (int i = 0; i < this.messageCount; ++i) {
                    producer.send((Message)MessagePriorityTest.this.sess.createTextMessage("message priority: " + this.priority));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

