/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.MessagePriorityTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCMessagePriorityTest
extends MessagePriorityTest {
    private static final Log LOG = LogFactory.getLog(JDBCMessagePriorityTest.class);

    protected PersistenceAdapter createPersistenceAdapter(boolean delete) throws Exception {
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName("derbyDb");
        dataSource.setCreateDatabase("create");
        dataSource.setShutdownDatabase("false");
        jdbc.setDataSource((DataSource)dataSource);
        jdbc.deleteAllMessages();
        jdbc.setCleanupPeriod(2000);
        return jdbc;
    }

    public void testDurableSubsReconnectWithFourLevels() throws Exception {
        ActiveMQTopic topic = (ActiveMQTopic)this.sess.createTopic("TEST");
        String subName = "priorityDisconnect";
        TopicSubscriber sub = this.sess.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        sub.close();
        int MED_PRI = this.LOW_PRI + 1;
        int MED_HIGH_PRI = this.HIGH_PRI - 1;
        MessagePriorityTest.ProducerThread lowPri = new MessagePriorityTest.ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.LOW_PRI);
        MessagePriorityTest.ProducerThread medPri = new MessagePriorityTest.ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, MED_PRI);
        MessagePriorityTest.ProducerThread medHighPri = new MessagePriorityTest.ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, MED_HIGH_PRI);
        MessagePriorityTest.ProducerThread highPri = new MessagePriorityTest.ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, this.HIGH_PRI);
        lowPri.start();
        highPri.start();
        medPri.start();
        medHighPri.start();
        lowPri.join();
        highPri.join();
        medPri.join();
        medHighPri.join();
        int closeFrequency = this.MSG_NUM;
        int[] priorities = new int[]{this.HIGH_PRI, MED_HIGH_PRI, MED_PRI, this.LOW_PRI};
        sub = this.sess.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        for (int i = 0; i < this.MSG_NUM * 4; ++i) {
            Message msg = sub.receive(10000L);
            LOG.debug((Object)("received i=" + i + ", m=" + (msg != null ? msg.getJMSMessageID() + ", priority: " + msg.getJMSPriority() : null)));
            JDBCMessagePriorityTest.assertNotNull((String)("Message " + i + " was null"), (Object)msg);
            JDBCMessagePriorityTest.assertEquals((String)("Message " + i + " has wrong priority"), (int)priorities[i / this.MSG_NUM], (int)msg.getJMSPriority());
            if (i <= 0 || i % closeFrequency != 0) continue;
            LOG.info((Object)("Closing durable sub.. on: " + i));
            sub.close();
            sub = this.sess.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        }
        LOG.info((Object)"closing on done!");
        sub.close();
    }

    public void initCombosForTestConcurrentDurableSubsReconnectWithXLevels() {
        this.addCombinationValues("prioritizeMessages", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testConcurrentDurableSubsReconnectWithXLevels() throws Exception {
        ActiveMQTopic topic = (ActiveMQTopic)this.sess.createTopic("TEST");
        String subName = "priorityDisconnect";
        Connection consumerConn = this.factory.createConnection();
        consumerConn.setClientID("priorityDisconnect");
        consumerConn.start();
        Session consumerSession = consumerConn.createSession(false, 1);
        TopicSubscriber sub = consumerSession.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        sub.close();
        int maxPriority = 5;
        Object[] messageCounts = new AtomicInteger[5];
        Vector<MessagePriorityTest.ProducerThread> producers = new Vector<MessagePriorityTest.ProducerThread>();
        for (int priority = 0; priority < 5; ++priority) {
            producers.add(new MessagePriorityTest.ProducerThread((ActiveMQDestination)topic, this.MSG_NUM, priority));
            messageCounts[priority] = new AtomicInteger(0);
        }
        for (MessagePriorityTest.ProducerThread producer : producers) {
            producer.start();
        }
        int closeFrequency = this.MSG_NUM / 2;
        HashMap<String, String> dups = new HashMap<String, String>();
        sub = consumerSession.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        for (int i = 0; i < this.MSG_NUM * 5; ++i) {
            Message msg = sub.receive(10000L);
            LOG.debug((Object)("received i=" + i + ", m=" + (msg != null ? msg.getJMSMessageID() + ", priority: " + msg.getJMSPriority() : null)));
            JDBCMessagePriorityTest.assertNull((String)("no duplicate message failed on : " + msg.getJMSMessageID()), (Object)dups.put(msg.getJMSMessageID(), "priorityDisconnect"));
            JDBCMessagePriorityTest.assertNotNull((String)("Message " + i + " was null"), (Object)msg);
            messageCounts[msg.getJMSPriority()].incrementAndGet();
            if (i <= 0 || i % closeFrequency != 0) continue;
            LOG.info((Object)("Closing durable sub.. on: " + i + ", counts: " + Arrays.toString(messageCounts)));
            sub.close();
            sub = consumerSession.createDurableSubscriber((Topic)topic, "priorityDisconnect");
        }
        LOG.info((Object)"closing on done!");
        sub.close();
        consumerSession.close();
        consumerConn.close();
        for (MessagePriorityTest.ProducerThread producer : producers) {
            producer.join();
        }
    }

    public static Test suite() {
        return JDBCMessagePriorityTest.suite(JDBCMessagePriorityTest.class);
    }
}

