/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterTestSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCPersistenceAdapterTest
extends PersistenceAdapterTestSupport {
    protected PersistenceAdapter createPersistenceAdapter(boolean delete) throws IOException {
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        jdbc.setEnableAudit(true);
        this.brokerService.setSchedulerSupport(false);
        this.brokerService.setPersistenceAdapter((PersistenceAdapter)jdbc);
        jdbc.setBrokerService(this.brokerService);
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName("derbyDb");
        dataSource.setCreateDatabase("create");
        jdbc.setDataSource((DataSource)dataSource);
        if (delete) {
            jdbc.deleteAllMessages();
        }
        return jdbc;
    }

    public void testAuditOff() throws Exception {
        this.pa.stop();
        this.pa = this.createPersistenceAdapter(true);
        ((JDBCPersistenceAdapter)this.pa).setEnableAudit(false);
        this.pa.start();
        boolean failed = true;
        try {
            this.testStoreCanHandleDupMessages();
            failed = false;
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        if (!failed) {
            JDBCPersistenceAdapterTest.fail((String)"Should have failed with audit turned off");
        }
    }
}

