/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCTestMemory
extends TestCase {
    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
    Connection conn;
    Session sess;
    Destination dest;
    BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName("derbyDb");
        dataSource.setCreateDatabase("create");
        jdbc.setDataSource((DataSource)dataSource);
        jdbc.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        broker.addConnector("tcp://0.0.0.0:61616");
        return broker;
    }

    protected BrokerService createRestartedBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName("derbyDb");
        dataSource.setCreateDatabase("create");
        jdbc.setDataSource((DataSource)dataSource);
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        broker.addConnector("tcp://0.0.0.0:61616");
        return broker;
    }

    public void init() throws Exception {
        this.conn = this.factory.createConnection();
        this.conn.start();
        this.sess = this.conn.createSession(false, 1);
        this.dest = this.sess.createQueue("test");
    }

    public void testRecovery() throws Exception {
        int i;
        this.init();
        MessageProducer producer = this.sess.createProducer(this.dest);
        for (i = 0; i < 1000; ++i) {
            producer.send((Message)this.sess.createTextMessage("test"));
        }
        producer.close();
        this.sess.close();
        this.conn.close();
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createRestartedBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.init();
        for (i = 0; i < 10; ++i) {
            new Thread("Producer " + i){

                public void run() {
                    try {
                        MessageProducer producer = JDBCTestMemory.this.sess.createProducer(JDBCTestMemory.this.dest);
                        for (int i = 0; i < 15000; ++i) {
                            producer.send((Message)JDBCTestMemory.this.sess.createTextMessage("test"));
                            if (i % 100 != 0) continue;
                            System.out.println(this.getName() + " sent message " + i);
                        }
                        producer.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            new Thread("Consumer " + i){

                public void run() {
                    try {
                        MessageConsumer consumer = JDBCTestMemory.this.sess.createConsumer(JDBCTestMemory.this.dest);
                        for (int i = 0; i < 15000; ++i) {
                            consumer.receive(2000L);
                            if (i % 100 != 0) continue;
                            System.out.println(this.getName() + " received message " + i);
                        }
                        consumer.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        System.in.read();
        this.sess.close();
        this.conn.close();
    }
}

