/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.RecoveryBrokerTest;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;

public class KahaDBStoreRecoveryBrokerTest
extends RecoveryBrokerTest {
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        kaha.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        return broker;
    }

    protected BrokerService createRestartedBroker() throws Exception {
        BrokerService broker = new BrokerService();
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        return broker;
    }

    public static Test suite() {
        return KahaDBStoreRecoveryBrokerTest.suite(KahaDBStoreRecoveryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)KahaDBStoreRecoveryBrokerTest.suite());
    }

    public void testLargeQueuePersistentMessagesNotLostOnRestart() throws Exception {
        MessageAck ack;
        Message m;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        ArrayList<String> expected = new ArrayList<String>();
        int MESSAGE_COUNT = 10000;
        for (int i2 = 0; i2 < MESSAGE_COUNT; ++i2) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
            message.setPersistent(true);
            connection.send((Command)message);
            expected.add(message.getMessageId().toString());
        }
        connection.request((Command)this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)producerInfo);
        for (i = 0; i < MESSAGE_COUNT / 2; ++i) {
            m = this.receiveMessage(connection);
            KahaDBStoreRecoveryBrokerTest.assertNotNull((String)("Should have received message " + (String)expected.get(0) + " by now!"), (Object)m);
            KahaDBStoreRecoveryBrokerTest.assertEquals((String)((String)expected.remove(0)), (String)m.getMessageId().toString());
            ack = this.createAck(consumerInfo, m, 1, (byte)2);
            connection.send((Command)ack);
        }
        connection.request((Command)this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        for (i = 0; i < MESSAGE_COUNT / 2; ++i) {
            m = this.receiveMessage(connection);
            KahaDBStoreRecoveryBrokerTest.assertNotNull((String)("Should have received message " + (String)expected.get(i) + " by now!"), (Object)m);
            KahaDBStoreRecoveryBrokerTest.assertEquals((String)((String)expected.get(i)), (String)m.getMessageId().toString());
            ack = this.createAck(consumerInfo, m, 1, (byte)2);
            connection.send((Command)ack);
        }
        connection.request((Command)this.closeConnectionInfo(connectionInfo));
    }
}

