/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.IOHelper;

public class KahaDBVersionTest
extends TestCase {
    static final File VERSION_1_DB = new File("src/test/resources/org/apache/activemq/store/kahadb/KahaDBVersion1");

    protected BrokerService createBroker(KahaDBPersistenceAdapter kaha) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(false);
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        broker.start();
        return broker;
    }

    public void XtestCreateStore() throws Exception {
        TextMessage msg;
        int i;
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        File dir = new File("src/test/resources/org/apache/activemq/store/kahadb/KahaDBVersion1");
        IOHelper.deleteFile((File)dir);
        kaha.setDirectory(dir);
        kaha.setJournalMaxFileLength(0x100000);
        BrokerService broker = this.createBroker(kaha);
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        connection.setClientID("test");
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic("test.topic");
        Queue queue = session.createQueue("test.queue");
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "test");
        consumer.close();
        MessageProducer producer = session.createProducer((Destination)topic);
        for (i = 0; i < 1000; ++i) {
            msg = session.createTextMessage("test message:" + i);
            producer.send((Message)msg);
        }
        producer = session.createProducer((Destination)queue);
        for (i = 0; i < 1000; ++i) {
            msg = session.createTextMessage("test message:" + i);
            producer.send((Message)msg);
        }
        connection.stop();
        broker.stop();
    }

    public void testVersionConversion() throws Exception {
        File testDir = new File("target/activemq-data/kahadb/versionDB");
        IOHelper.deleteFile((File)testDir);
        IOHelper.copyFile((File)VERSION_1_DB, (File)testDir);
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setDirectory(testDir);
        kaha.setJournalMaxFileLength(0x100000);
        BrokerService broker = this.createBroker(kaha);
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        connection.setClientID("test");
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic("test.topic");
        Queue queue = session.createQueue("test.queue");
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 1000; ++i) {
            TextMessage msg = (TextMessage)queueConsumer.receive(10000L);
            KahaDBVersionTest.assertNotNull((Object)msg);
        }
        TopicSubscriber topicConsumer = session.createDurableSubscriber(topic, "test");
        for (int i = 0; i < 1000; ++i) {
            TextMessage msg = (TextMessage)topicConsumer.receive(10000L);
            KahaDBVersionTest.assertNotNull((Object)msg);
        }
        broker.stop();
    }
}

