/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.retroactive;

import java.net.URI;
import java.util.Date;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.MessageIdList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetroactiveConsumerTestWithSimpleMessageListTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(RetroactiveConsumerTestWithSimpleMessageListTest.class);
    protected int messageCount = 20;
    protected Connection connection;
    protected Session session;

    public void testSendThenConsume() throws Exception {
        this.connection = this.createConnection();
        this.session = this.connection.createSession(false, 1);
        MessageProducer producer = this.createProducer();
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.session.createTextMessage("Message: " + i + " sent at: " + new Date());
            this.sendMessage(producer, message);
        }
        producer.close();
        this.session.close();
        this.connection.close();
        this.connection = this.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        MessageConsumer consumer = this.createConsumer();
        MessageIdList listener = new MessageIdList();
        consumer.setMessageListener((MessageListener)listener);
        listener.waitForMessagesToArrive(this.messageCount);
        listener.assertMessagesReceived(this.messageCount);
    }

    protected void setUp() throws Exception {
        this.useTopic = true;
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory(this.bindAddress);
        answer.setUseRetroactiveConsumer(true);
        return answer;
    }

    protected BrokerService createBroker() throws Exception {
        String uri = this.getBrokerXml();
        LOG.info((Object)("Loading broker configuration from the classpath with URI: " + uri));
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    protected void startBroker() throws Exception {
    }

    protected String getBrokerXml() {
        return "org/apache/activemq/test/retroactive/activemq-fixed-buffer.xml";
    }

    protected MessageProducer createProducer() throws JMSException {
        return this.session.createProducer((Destination)this.destination);
    }

    protected void sendMessage(MessageProducer producer, TextMessage message) throws JMSException {
        producer.send((Message)message);
    }

    protected MessageConsumer createConsumer() throws JMSException {
        return this.session.createConsumer((Destination)this.destination);
    }
}

