/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FailoverConsumerUnconsumedTest {
    private static final Log LOG = LogFactory.getLog(FailoverConsumerUnconsumedTest.class);
    private static final String QUEUE_NAME = "FailoverWithUnconsumed";
    private String url = "tcp://localhost:61616";
    final int prefetch = 10;
    BrokerService broker;
    static long idGen = 100L;

    public void startCleanBroker() throws Exception {
        this.startBroker(true);
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = new BrokerService();
        this.broker.addConnector(this.url);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        return this.broker;
    }

    @Test
    public void testFailoverConsumerDups() throws Exception {
        this.doTestFailoverConsumerDups(true);
    }

    @Test
    public void testFailoverConsumerDupsNoAdvisoryWatch() throws Exception {
        this.doTestFailoverConsumerDups(false);
    }

    public void doTestFailoverConsumerDups(final boolean watchTopicAdvisories) throws Exception {
        int maxConsumers = 4;
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){
            int consumerCount;

            public Subscription addConsumer(ConnectionContext context, final ConsumerInfo info) throws Exception {
                if (++this.consumerCount == 4 + (watchTopicAdvisories ? 1 : 0)) {
                    context.setDontSendReponse(true);
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        public void run() {
                            LOG.info((Object)("Stopping broker on consumer: " + info.getConsumerId()));
                            try {
                                FailoverConsumerUnconsumedTest.this.broker.stop();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                return super.addConsumer(context, info);
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(watchTopicAdvisories);
        final ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session consumerSession = connection.createSession(false, 1);
        final Queue destination = consumerSession.createQueue("FailoverWithUnconsumed?jms.consumer.prefetch=10");
        final Vector<TestConsumer> testConsumers = new Vector<TestConsumer>();
        for (int i = 0; i < 3; ++i) {
            testConsumers.add(new TestConsumer(consumerSession, (Destination)destination, connection));
        }
        this.produceMessage(consumerSession, destination, 40L);
        Assert.assertTrue((String)"add messages are dispatched", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalUnconsumed = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long unconsumed = testConsumer.unconsumedSize();
                    LOG.info((Object)(testConsumer.getConsumerId() + " unconsumed: " + unconsumed));
                    totalUnconsumed = (int)((long)totalUnconsumed + unconsumed);
                }
                return totalUnconsumed == 30;
            }
        }));
        final CountDownLatch commitDoneLatch = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                try {
                    LOG.info((Object)"add last consumer...");
                    testConsumers.add(new TestConsumer(consumerSession, (Destination)destination, connection));
                    commitDoneLatch.countDown();
                    LOG.info((Object)"done add last consumer");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.broker.waitUntilStopped();
        Assert.assertTrue((String)"add messages dispatched and unconsumed are cleaned up", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalUnconsumed = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long unconsumed = testConsumer.unconsumedSize();
                    LOG.info((Object)(testConsumer.getConsumerId() + " unconsumed: " + unconsumed));
                    totalUnconsumed = (int)((long)totalUnconsumed + unconsumed);
                }
                return totalUnconsumed == 0;
            }
        }));
        this.broker = this.createBroker(false);
        this.broker.start();
        Assert.assertTrue((String)"consumer added through failover", (boolean)commitDoneLatch.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"after start all messages are re dispatched", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalUnconsumed = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long unconsumed = testConsumer.unconsumedSize();
                    LOG.info((Object)(testConsumer.getConsumerId() + " after restart: unconsumed: " + unconsumed));
                    totalUnconsumed = (int)((long)totalUnconsumed + unconsumed);
                }
                return totalUnconsumed == 40;
            }
        }));
        connection.close();
    }

    private void produceMessage(Session producerSession, Queue destination, long count) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        int i = 0;
        while ((long)i < count) {
            TextMessage message = producerSession.createTextMessage("Test message " + i);
            producer.send((Message)message);
            ++i;
        }
        producer.close();
    }

    private static long nextGen() {
        return idGen -= 5L;
    }

    class TestConsumer
    extends ActiveMQMessageConsumer {
        TestConsumer(Session consumerSession, Destination destination, ActiveMQConnection connection) throws Exception {
            super((ActiveMQSession)consumerSession, new ConsumerId(new SessionId(connection.getConnectionInfo().getConnectionId(), 1L), FailoverConsumerUnconsumedTest.nextGen()), ActiveMQMessageTransformation.transformDestination((Destination)destination), null, "", 10, -1, false, false, true, null);
        }

        public int unconsumedSize() {
            return this.unconsumedMessages.size();
        }
    }
}

