/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class FailoverTimeoutTest
extends TestCase {
    private static final String QUEUE_NAME = "test.failovertimeout";

    public void testTimeout() throws Exception {
        long timeout = 1000L;
        URI tcpUri = new URI("tcp://localhost:61616");
        BrokerService bs = new BrokerService();
        bs.setUseJmx(false);
        bs.addConnector(tcpUri);
        bs.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + tcpUri + ")?timeout=" + timeout + "&useExponentialBackOff=false");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
        TextMessage message = session.createTextMessage("Test message");
        producer.send((Message)message);
        bs.stop();
        try {
            producer.send((Message)message);
        }
        catch (JMSException jmse) {
            FailoverTimeoutTest.assertEquals((String)("Failover timeout of " + timeout + " ms reached."), (String)jmse.getMessage());
        }
        bs = new BrokerService();
        bs.setUseJmx(false);
        bs.addConnector(tcpUri);
        bs.start();
        bs.waitUntilStarted();
        producer.send((Message)message);
        bs.stop();
    }
}

